<?php
// Configurações do banco de dados
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

// Estabelece a conexão com o banco de dados
try {
    $conn = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die('Erro na conexão com o banco de dados: ' . $e->getMessage());
}

// Obtém o ID do feed da URL
$feedId = isset($_GET['id']) ? $_GET['id'] : die('Feed ID não fornecido.');

// Consulta para obter os detalhes do feed
$stmt = $conn->prepare("SELECT * FROM pinfeeds WHERE id = :id");
$stmt->execute(['id' => $feedId]);
$feed = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$feed) {
    die('Feed não encontrado.');
}

// Detalhes do feed
$feedTitle = htmlspecialchars($feed['title']);
$feedDescription = htmlspecialchars($feed['description']);
$feedImage = htmlspecialchars($feed['thumbnail']);
$feedUrl = "https://digupdog.com/pindetails.php?id=" . $feedId;

// Cabeçalho HTML com metatags dinâmicas
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $feedTitle; ?></title>
    <meta property="og:title" content="<?php echo $feedTitle; ?>" />
    <meta property="og:description" content="<?php echo $feedDescription; ?>" />
    <meta property="og:image" content="<?php echo $feedImage; ?>" />
    <meta property="og:url" content="<?php echo $feedUrl; ?>" />
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo $feedTitle; ?>">
    <meta name="twitter:description" content="<?php echo $feedDescription; ?>">
    <meta name="twitter:image" content="<?php echo $feedImage; ?>">

	<title>Pr&eacute;-Visualiza&ccedil;&atilde;o e Edi&ccedil;&atilde;o</title>
	<link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet" />
	<style type="text/css">body {
            font-family: Arial, sans-serif;
            font-size: 20px;
            background-color: #ffffff;
            margin: 0;
            padding-top: 50px; /* Adiciona espaço para a barra de busca fixa */
        }

/* Estilos para o modo escuro */
body.dark-mode {
  background-color: #333;
  color: #fff;
}

.short-text {
    display: none; /* esconde o texto curto por padrão */
}

@media (max-width: 768px) {
    .full-text {
        display: none; /* esconde o texto completo em telas pequenas */
    }

    .short-text {
        display: inline; /* mostra o texto curto em telas pequenas */
    }
}


        @media (min-width: 4800px) {
            .result-list {
                grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
            }
        }






    /* Estilos para o rodapé */
    footer {
        position: fixed;
        left: 0;
        bottom: 0;
        width: 100%;
        text-align: center;
        font-size: 8px;
        padding: 3px;
        background-color: #f2f2f2;
        border-top: 1px solid #ccc;
    }



.category-buttons-container {
  position: fixed;
  top: 10px;
  left: 0;
  right: 0;
  z-index: 998;
  max-width: 100%;
  width: 90%;
  margin-left: auto;
  margin-right: auto;
  overflow-x: auto;
  white-space: nowrap;
  padding: 5px;
  background-color: transparent; /* Torna o fundo transparente */
  box-shadow: 0 2px 10px rgba(0,0,0,0.1); /* Adicione sombra para profundidade */
  overflow: hidden;
}

.category-buttons {
  display: flex;
  justify-content: space-between; /* Posiciona os botões nas extremidades */
  align-items: center;
}

.left-arrow,
.right-arrow {
  display: flex;
  align-items: center;
  justify-content: center;
  width: 30px;
  height: 30px;
  background-color: #F7F7F7;
  border-radius: 50%;
  font-size: 1.2rem;
  color: #333333;
  cursor: pointer;
  transition: background-color 0.3s ease, transform 0.3s ease;
  box-shadow: 0 2px 5px rgba(0,0,0,0.1); /* Adicione sombra para profundidade */
}

.left-arrow:hover,
.right-arrow:hover {
  background-color: #EAEAEA;
  transform: scale(1.1); /* Efeito de zoom ao passar o mouse */
}

.category-button {
    margin: 0 0.5rem;
    background-color: #F7F7F7;
    border: none;
    border-radius: 0.4rem;
    padding: 0.5rem 1rem;
    font-size: 0.8rem;
    cursor: pointer;
    transition: background-color 0.3s ease, transform 0.3s ease;
    font-family: 'Arial', sans-serif; /* Substitua por qualquer fonte de sua escolha */
    box-shadow: 0 2px 5px rgba(0,0,0,0.1); /* Adicione sombra para profundidade */
}

.category-button:hover {
    background-color: #EAEAEA;
    transform: scale(1.05); /* Adicione um efeito de "zoom" ao passar o mouse */
}

        .category-buttons-wrapper {
            display: flex;
            align-items: center;
            overflow-x: auto;
            scrollbar-width: none;
        }

        .category-buttons-wrapper::-webkit-scrollbar {
            display: none;
        }

.category-button.all {
    background-color: #e8e9e8;
    color: #000000;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}

.category-button.all:hover {
    background-color: #d2d3d2;
}


.category-button.world-news {
    background-color: #e8e9e8;
    color: #000000;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}

.category-button.world-news:hover {
    background-color: #d2d3d2;
}

.category-button.entertainment {
    background-color: #e8e9e8;
    color: #000000;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}

.category-button.entertainment:hover {
    background-color: #d2d3d2;
}


.category-button.sports {
    background-color: #e8e9e8;
    color: #000000;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}

.category-button.sports:hover {
    background-color: #d2d3d2;
}

.category-button.videogames {
    background-color: #e8e9e8;
    color: #000000;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}

.category-button.videogames:hover {
    background-color: #d2d3d2;
}

.category-button.pins {
    background-color: #1f8aef;
    color: #ffffff;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}

.category-button.pins:hover {
    background-color: #d2d3d2;
}

.category-button.plus {
    background-color: #ff0000;
    color: #ffffff;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}

.category-button.plus:hover {
    background-color: #d2d3d2;
}

.category-button.pin {
    background-color: #1f8aef;
    color: #ffffff;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 10px; /* Espaçamento horizontal de 10px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}



.category-button.pin:hover {
    background-color: #d2d3d2;
}




/* Estilos para o botão "Modo Escuro" */
#dark-mode-toggle {
            background-color: #333;
            border: none;
            border-radius: .4rem;
            color: #ffffff;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}            outline: none;
            transition: background-color 0.3s ease;
            display: flex;
            justify-content: center;
            align-items: center;
    overflow: visible; /* permite que o conteúdo ultrapasse os limites do botão */
  margin-right: 5px;
}

#dark-mode-toggle:hover {
  background-color: #555;
}

/* Estilos para o modo escuro */
body.dark-mode {
  background-color: #333;
  color: #fff;
}
	</style>
</head>
<body>
<div class="category-buttons-container">
<div class="category-buttons">
<div class="left-arrow"></div>

<div class="category-buttons-wrapper"><a class="category-button pins" href="https://digupdog.com" target="_self">Pins</a><a class="category-button all" href="https://digupdog.net/FEED/home.html" target="_self">All</a><a class="category-button world-news" href="https://digupdog.net/FEED/news.html" target="_self">World News</a><a class="category-button entertainment" href="https://digupdog.net/FEED/entertainment.html" target="_self">Entertainment</a><a class="category-button sports" href="https://digupdog.net/FEED/sports.html" target="_self">Sports</a><a class="category-button videogames" href="https://digupdog.net/FEED/videogames.html" target="_self">Video Games</a><a class="category-button plus" href="https://digupdog.com/plus" target="_self">18+</a><a class="category-button pin" href="https://digupdog.com/aaa1" target="_self">+</a><button id="dark-mode-toggle"><span class="full-text">Dark</span><span class="short-text">D</span></button></div>

<div class="right-arrow"></div>
</div>
</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script><script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script><script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script><script>
var container = document.querySelector('.category-buttons-container');
var wrapper = document.querySelector('.category-buttons-wrapper');
var leftArrow = document.querySelector('.left-arrow');
var rightArrow = document.querySelector('.right-arrow');
var scrollAmount = 0;
var scrollStep = 5;
var scrollInterval;

function startScrollLeft() {
    scrollInterval = setInterval(function() {
        wrapper.scrollLeft -= scrollStep;  // Ajuste o valor de scrollLeft diretamente
    }, 10);
}

function startScrollRight() {
    scrollInterval = setInterval(function() {
        wrapper.scrollLeft += scrollStep;  // Ajuste o valor de scrollLeft diretamente
    }, 10);
}

function stopScroll() {
  clearInterval(scrollInterval);
}

leftArrow.addEventListener('mousedown', startScrollLeft);
leftArrow.addEventListener('mouseup', stopScroll);
leftArrow.addEventListener('mouseleave', stopScroll);
rightArrow.addEventListener('mousedown', startScrollRight);
rightArrow.addEventListener('mouseup', stopScroll);
rightArrow.addEventListener('mouseleave', stopScroll);

leftArrow.addEventListener('touchstart', startScrollLeft);
leftArrow.addEventListener('touchend', stopScroll);
rightArrow.addEventListener('touchstart', startScrollRight);
rightArrow.addEventListener('touchend', stopScroll);



// Seletor para o botão de alternar modo escuro
const darkModeToggle = document.querySelector('#dark-mode-toggle');

// Evento de clique no botão
darkModeToggle.addEventListener('click', function() {
  // Adiciona ou remove a classe 'dark-mode' no elemento body
  document.body.classList.toggle('dark-mode');
});

</script></body>
</html>
<title></title>
<meta name="viewport" content="width=device-width, initial-scale=1"><meta id="base-url" content="https://digupdog.com/"><!-- AddToAny Share Button Library --><script async src="https://static.addtoany.com/menu/page.js"></script>
<style type="text/css">body {
        font-family: Arial, sans-serif;
        font-size: 20px;
        background-color: #ffffff;
        margin: 0;
        padding-top: 50px; /* Adiciona espaço para a barra de busca fixa */
    }
    .grid-container {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
            max-width: 92%;
            margin: 0 auto;
            margin-top: 5.5rem;
            margin-bottom: 4.5rem;
        }

    .result {
        overflow: hidden;
        background-color: #FFFFFF;
        border: 1px solid #ccc; /* Adiciona uma borda */
        border-radius: 10px;
        box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        transition: box-shadow 0.3s ease;
        margin: 20px auto; /* Aumenta a margem para criar mais espaço entre os itens */
        padding: 5px; /* Aumenta o padding para dar mais espaço dentro de cada item */
        width: 30%; /* Faz com que cada item ocupe todo o espaço disponível em sua célula da grid */
    }

    .related-feeds {
        overflow: hidden;
        background-color: #FFFFFF;
        border: 1px solid #ccc; /* Adiciona uma borda */
        border-radius: 10px;
        box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        transition: box-shadow 0.3s ease;
        margin: 20px; /* Aumenta a margem para criar mais espaço entre os itens */
        padding: 5px; /* Aumenta o padding para dar mais espaço dentro de cada item */
        width: 100%; /* Faz com que cada item ocupe todo o espaço disponível em sua célula da grid */
    }

    .result:hover, .related-feeds:hover {
        box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.2);
    }

    .result img, .related-feeds img { 
        width: 100%;
        height: auto;
        object-fit: contain;
        border-radius: 10px 10px 0 0;
        display: block; /* garante que a imagem seja o único elemento na linha */
        margin: 0 auto; /* centraliza a imagem */

    }

    .result h2, .related-feeds h2 {
        font-size: 18px;
        margin: 10px;
        margin-top: 0; /* Remove margem superior */
        font-weight: 700;
        color: #333333;
    }

    .result p, .related-feeds p {
        font-size: 14px;
        margin: 0; /* Remove margem */
        color: #666666;
        line-height: 1.4; /* Altera a altura da linha */
    }

    .result a, .related-feeds a {
        color: #000000; /* Altera a cor do link */
        font-weight: bold; /* Torna o link em negrito */
    }


    /* estilos de responsividade */

    @media (max-width: 1400px) {
        .result, .related-feeds {
            width: 90%; /* aumenta a largura do resultado em telas pequenas */
        }
        .full-text {
            display: none; /* esconde o texto completo em telas pequenas */
        }
        .short-text {
            display: inline; /* mostra o texto curto em telas pequenas */
        }    
    }

#load-more-button {
    background-color: #ff0000;
    border: none;
    border-radius: .4rem;
    color: #ffffff;
    cursor: pointer;
    font-size: 1.5rem;
    font-weight: bold;
    height: 2rem;
    width: auto; 
    display: flex;
    justify-content: center;
    align-items: center;
    margin: 0 auto 20px auto;
    padding: 10px 20px; 
    transition: background-color 0.3s ease; /* transition to make the color change smoother */
}

#load-more-button:hover {
    background-color: #cc0000; /* darken the red a bit when hovering */
}

#load-more-button:active {
    background-color: #ff4d4d; /* lighten the red a bit when active (being clicked) */
}

#myBtn {
            display: none;
            position: fixed;
            bottom: 40px;
            right: 12px;
            z-index: 99;
            font-size: 18px;
            border: none;
            outline: none;
            background-color: red;
            color: white;
            cursor: pointer;
            padding: 15px;
            border-radius: 4px;
        }

        #myBtn:hover {
            background-color: #d2d3d2;
        }
</style>
<div class="result" id="feed-details"></div>

<div class="grid-container" id="related-feeds"></div>

<p><button id="load-more-button">Load More</button></p>

<p><button id="myBtn" onclick="topFunction()" title="Go to top">Top</button></p>
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script><script>
    // Function to add the share button to feed details
    function createShareButton(feedId) {
      var baseUrl = $('meta#base-url').attr('content');
      var feedLink = baseUrl + 'pindetails.php?id=' + feedId;
  
      var shareButtonHtml = `<div class="a2a_kit a2a_kit_size_24 a2a_default_style">
        <a class="a2a_dd" href="https://www.addtoany.com/share"></a>
      </div>`;
  
      var shareButton = $(shareButtonHtml);
      shareButton.attr('data-a2a-url', feedLink); // Configura o link para compartilhar
      return shareButton;
    }
  
    // Function to initialize share buttons for a related feed section
    function initializeShareButtons(relatedFeedSection) {
      // Initialize AddToAny script for the share buttons in this section
      a2a.init('page');
    }
  
function extractTagsFromTitle(title) {
    console.log("Extraindo tags do título: ", title);

    // Normaliza o título removendo pontuação e convertendo para minúsculas
    let normalizedTitle = title.replace(/[.,\/#!$%\^&\*;:{}=\-_`~()]/g, "").toLowerCase();

    // Divide o título em palavras
    let words = normalizedTitle.split(" ");

    // Lista de palavras comuns estendida
    let commonWords = ["a", "an", "the", "and", "or", "but", "in", "at", "on", "with", "to", "–", "for", "is", "of", "that", "it", "by", "from", "as", "are", "was", "be", "has", "have", "will", "this", "which", "its", "about", "up", "more", "who", "also", "they", "out", "he", "she", "you", "their", "we", "her", "his", "them", "been", "these", "would", "some", "can", "like", "there", "if", "all", "my", "what", "so", "then", "into", "just", "over", "do", "than", "when", "other", "how", "our", "any", "new", "me", "after", "most", "made", "only", "time", "will", "where", "year", "years", "make", "does", "could", "were", "your", "good", "well", "them"];

    // Filtra as palavras pequenas e comuns
    let keywords = words.filter(word => !commonWords.includes(word) && word.length > 2);

    console.log("Tags extraídas: ", keywords);

    return keywords;
}


function formatTitleForURL(title) {
    // Convertendo o título para letras minúsculas
    title = title.toLowerCase();
    
    // Removendo caracteres especiais e substituindo espaços por hifens
    title = title.replace(/[^a-z0-9\s]/gi, '').replace(/[_\s]/g, '-');
    
    // Limitando o comprimento para evitar URLs muito longas (opcional)
    if(title.length > 50) {
        title = title.substring(0, 50);
    }

    return title;
}



function displayFeedDetails(feedId, feed) {
    console.log("Exibindo detalhes do feed: ", feed);

    const container = $('#feed-details');

    let feedHtml = `
    <h2>${feed.title || 'Sem título'}</h2>
    ${feed.thumbnail && !feed.description.includes(feed.thumbnail) ? `<img class="feed-thumbnail" src="${feed.thumbnail}" alt="Thumbnail">` : ''}
    <p>${feed.description || ''}</p>
    <p>${feed.pubDate || ''}</p>
    <a href="${feed.link}" target="_blank" rel="noopener noreferrer">Source Link</a>
    `;

    // Extrai as tags do título
    let tags = extractTagsFromTitle(feed.title || '');

    // Adiciona as tags ao HTML
    feedHtml += `<p>Tags: ${tags.join(", ")}</p>`;

    console.log("Adicionando HTML ao container: ", feedHtml);

    container.append(feedHtml);

    // Adiciona o botão de compartilhamento usando createShareButton function
    const shareButton = createShareButton(feedId);
    container.append(shareButton);

    // Inicializa o script AddToAny para o botão de compartilhamento
    initializeShareButtons(container);
}
  
    // Your existing JavaScript code...
    $(document).ready(async function() {
        const urlParams = new URLSearchParams(window.location.search);
        const feedId = urlParams.get('id');
        let page = 1;
        let loading = false;
        let noMoreFeeds = false;

        const container = $('#feed-details');

        if (!feedId) {
            container.append('<p>Feed não encontrado.</p>');
            return;
        }

        try {
            const feed = await $.getJSON('get_feed_pindetails.php', { id: feedId });
            
            // Atualiza a URL com o título formatado após obter os detalhes do feed
            const formattedTitle = formatTitleForURL(feed.title || '');
            const currentURL = window.location.href;
            const baseURL = currentURL.split('?')[0];
            const newURL = `${baseURL}?id=${feedId}&title=${formattedTitle}`;
            window.history.pushState({ path: newURL }, '', newURL);

            displayFeedDetails(feedId, feed);
  
        await loadRelatedFeeds();
  
        $('#load-more-button').click(function() {
          if (!loading && !noMoreFeeds) {
            loadRelatedFeeds();
          }
        });
      } catch (error) {
        console.error('Error fetching feeds:', error);
      }

      

async function loadRelatedFeeds() {
  loading = true;
  try {
    const relatedFeeds = await $.getJSON('get_related_pinfeeds.php', { id: feedId, page: page });
    if (relatedFeeds.length === 0) {
      noMoreFeeds = true;
      $('#load-more-button').prop('disabled', true);
      return;
    }

    let relatedFeedsHtml = '';
relatedFeeds.forEach(relatedFeed => {
  const faviconLink = relatedFeed.link ? new URL(relatedFeed.link).origin + '/favicon.ico' : '';
  const originalLink = relatedFeed.link || '';
  const faviconHtml = faviconLink ? `<a href="${originalLink}" target="_blank" rel="noopener noreferrer" style="display: block; margin-bottom: 5px;"><img src="${faviconLink}" alt="Favicon" style="width: 24px; height: 24px;" /></a>` : ''; 
  const shareButton = createShareButton(relatedFeed.id);
  const shareButtonHtml = shareButton.prop('outerHTML');
  const descriptionHtml = relatedFeed.description ? `<p>${relatedFeed.description}</p>` : 'Sem descrição'; // Assuming descriptions can be directly inserted into the HTML

  relatedFeedsHtml += `
    <div class="related-feeds">
      ${relatedFeed.thumbnail ? `<a href="pindetails.php?id=${relatedFeed.id} rel="noopener noreferrer"><img src="${relatedFeed.thumbnail}" alt="Thumbnail"></a>` : ''}
      <h2><a href="pindetails.php?id=${relatedFeed.id} rel="noopener noreferrer">${relatedFeed.title || 'Sem título'}</a></h2>
      ${descriptionHtml}
      <div style="display: flex;">
        <div style="flex-direction: column;">
          ${faviconHtml} <!-- Favicon à esquerda, acima do botão de compartilhamento -->
          ${shareButtonHtml}
        </div>
      </div>
    </div>
  `;
});


    const $relatedFeedsContainer = $('#related-feeds');
    $relatedFeedsContainer.append(relatedFeedsHtml);

    // Inicializar botões de compartilhamento
    $relatedFeedsContainer.find('.related-feeds').each((index, element) => {
      initializeShareButtons($(element));
    });

    page++;
  } catch (error) {
    console.error('Error fetching related feeds:', error);
  }
  loading = false;
}


    });

let mybutton = document.getElementById("myBtn");

// Quando o usuário rolar 20px a partir do topo do documento, mostrar o botão
window.onscroll = function() {
scrollFunction();
};

function scrollFunction() {
if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
mybutton.style.display = "block";
} else {
mybutton.style.display = "none";
}
}

// Quando o usuário clicar no botão, rolar para o topo do documento
function topFunction() {
document.body.scrollTop = 0;
document.documentElement.scrollTop = 0;
}
  </script>