<?php
require_once __DIR__ . '/bootstrap.php';

$action = route_action();
if ($action === 'get_chat_rooms') handle_get_rooms();
if ($action === 'chat_send') handle_send();
if ($action === 'chat_fetch') handle_fetch();

json_fail('UNKNOWN_ACTION', 'No such chat action: ' . $action, 404);

function handle_get_rooms() {
    $pdo = pdo();
    if (!table_exists('chat_rooms')) json_fail('UNAVAILABLE','chat tables not present', 503, ['available'=>false]);
    $rows = $pdo->query("SELECT id, feed_id, name, description, is_active, created_at FROM chat_rooms WHERE is_active = 1 ORDER BY created_at DESC LIMIT 200")->fetchAll();
    json_ok(['rooms'=>$rows, 'available'=>true]);
}

function handle_send() {
    $user = require_user();
    $pdo = pdo();
    if (!table_exists('chat_messages')) json_fail('UNAVAILABLE','chat tables not present', 503, ['available'=>false]);
    $room_id = (int)param('room_id', 0);
    $message = trim((string)param('message',''));
    if ($room_id<=0 || $message==='') json_fail('BAD_REQUEST','room_id and message required', 422);
    $sql = "INSERT INTO chat_messages (room_id, user_id, message, message_type, created_at) VALUES (:r,:u,:m,'text',NOW())";
    $pdo->prepare($sql)->execute([':r'=>$room_id, ':u'=>$user['ID'], ':m'=>$message]);
    json_ok(['sent'=>true]);
}

function handle_fetch() {
    $pdo = pdo();
    if (!table_exists('chat_messages')) json_fail('UNAVAILABLE','chat tables not present', 503, ['available'=>false]);
    $room_id = (int)param('room_id', 0);
    $after_id = (int)param('after_id', 0);
    $limit = min(200, max(1, (int)param('limit', 50)));
    if ($room_id<=0) json_fail('BAD_REQUEST','room_id required', 422);
    $sql = "SELECT m.id, m.room_id, m.user_id, u.username, m.message, m.created_at FROM chat_messages m LEFT JOIN user_myhashtag u ON u.ID = m.user_id WHERE m.room_id = :r " . ($after_id>0 ? " AND m.id > :a " : "") . " ORDER BY m.id ASC LIMIT :lim";
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':r', $room_id, PDO::PARAM_INT);
    if ($after_id>0) $stmt->bindValue(':a', $after_id, PDO::PARAM_INT);
    $stmt->bindValue(':lim', $limit, PDO::PARAM_INT);
    $stmt->execute();
    json_ok(['messages'=>$stmt->fetchAll(), 'available'=>true]);
}
