<?php
require_once __DIR__ . '/bootstrap.php';

$action = route_action();
if ($action === 'link_preview') handle_preview();

json_fail('UNKNOWN_ACTION', 'No such link preview action: ' . $action, 404);

function handle_preview() {
    $pdo = pdo();
    $url = trim((string)param('url',''));
    if ($url === '') json_fail('BAD_REQUEST','url required', 422);
    $hash = sha1($url);

    $og = null;
    if (table_exists('link_og_cache')) {
        $stmt = $pdo->prepare("SELECT url, title, description, image, fetched_at FROM link_og_cache WHERE url_hash = :h LIMIT 1");
        $stmt->execute([':h'=>$hash]);
        $og = $stmt->fetch();
    }
    if (!$og && table_exists('link_previews')) {
        $stmt = $pdo->prepare("SELECT url, title, description, image_url as image, domain, created_at FROM link_previews WHERE url = :u LIMIT 1");
        $stmt->execute([':u'=>$url]);
        $og = $stmt->fetch();
    }
    if (!$og) {
        // No external fetch here (hosted env may block). Return minimal.
        $p = parse_url($url);
        $og = [
            'url' => $url,
            'title' => $url,
            'description' => 'Preview not cached yet',
            'image' => null,
            'domain' => $p['host'] ?? null,
        ];
    }
    json_ok(['preview'=>$og]);
}
