<?php
// Simple front-controller to route API actions to the corresponding file.
// You can hit: /api/router.php?action=get_pinfeeds  (and others)
require_once __DIR__ . '/bootstrap.php';

$action = route_action();
if ($action === '') json_fail('MISSING_ACTION','Pass ?action=...');

$map = [
    // Feeds & discovery
    'get_pinfeeds'   => __DIR__ . '/feeds.php',
    'get_feed'       => __DIR__ . '/feeds.php',
    'get_trending'   => __DIR__ . '/feeds.php',
    'get_sources'    => __DIR__ . '/feeds.php',
    'get_hashtags'   => __DIR__ . '/feeds.php',
    'search'         => __DIR__ . '/feeds.php',

    // Auth
    'auth_register'  => __DIR__ . '/auth.php',
    'auth_login'     => __DIR__ . '/auth.php',
    'auth_logout'    => __DIR__ . '/auth.php',

    // Comments
    'get_comments'   => __DIR__ . '/comments.php',
    'post_comment'   => __DIR__ . '/comments.php',

    // Reactions
    'post_reaction'  => __DIR__ . '/reactions.php',

    // Favorites
    'favorite_toggle'=> __DIR__ . '/favorites.php',
    'get_user_favorites'=> __DIR__ . '/favorites.php',

    // Follows
    'follow_user'    => __DIR__ . '/follows.php',

    // Boards
    'get_boards'     => __DIR__ . '/boards.php',
    'board_add_item' => __DIR__ . '/boards.php',

    // Chat
    'get_chat_rooms' => __DIR__ . '/chat.php',
    'chat_send'      => __DIR__ . '/chat.php',
    'chat_fetch'     => __DIR__ . '/chat.php',

    // Upload & OG
    'upload_media'   => __DIR__ . '/upload.php',
    'link_preview'   => __DIR__ . '/linkpreview.php',

    // Profiles
    'get_user_profile' => __DIR__ . '/profile.php',
];

if (!isset($map[$action])) {
    json_fail('UNKNOWN_ACTION','No route for '.$action,404);
}

require $map[$action];
