<?php
require_once __DIR__ . '/bootstrap.php';

$action = route_action();
if ($action === 'upload_media') handle_upload();

json_fail('UNKNOWN_ACTION', 'No such upload action: ' . $action, 404);

function handle_upload() {
    $user = require_user();
    if (empty($_FILES['file'])) json_fail('BAD_REQUEST','file required (multipart/form-data)', 422);

    $file = $_FILES['file'];
    if ($file['error'] !== UPLOAD_ERR_OK) json_fail('UPLOAD_ERROR','Upload failed code '.$file['error'], 400);

    $allowed = ['image/jpeg'=>'jpg','image/png'=>'png','image/gif'=>'gif','image/webp'=>'webp'];
    $type = mime_content_type($file['tmp_name']);
    if (!isset($allowed[$type])) json_fail('UNSUPPORTED','Only images are allowed', 415);
    if ($file['size'] > 10*1024*1024) json_fail('TOO_LARGE','Max 10MB', 413);

    $ext = $allowed[$type];
    $name = bin2hex(random_bytes(8)) . '.' . $ext;
    $destDir = realpath(__DIR__ . '/../uploads');
    if (!$destDir) $destDir = __DIR__ . '/../uploads';
    $dest = $destDir . DIRECTORY_SEPARATOR . $name;
    if (!@move_uploaded_file($file['tmp_name'], $dest)) {
        // fallback to copy
        if (!@copy($file['tmp_name'], $dest)) {
            json_fail('WRITE_FAILED','Cannot save file to uploads/, check permissions', 500);
        }
    }

    $relUrl = dirname($_SERVER['SCRIPT_NAME']) . '/../uploads/' . $name;
    $relUrl = preg_replace('#/api/?$#', '/uploads/' . $name, dirname($_SERVER['SCRIPT_NAME']));

    // Persist in DB
    $pdo = pdo();
    if (table_exists('uploaded_media')) {
        $stmt = $pdo->prepare("INSERT INTO uploaded_media (user_id, filename, original_filename, file_type, file_size, file_url, upload_type, created_at) VALUES (:u,:fn,:ofn,:ft,:fs,:url,'image',NOW())");
        $stmt->execute([
            ':u' => get_user()['ID'],
            ':fn'=> $name,
            ':ofn'=>$file['name'],
            ':ft'=> $type,
            ':fs'=> (int)$file['size'],
            ':url'=> $relUrl,
        ]);
    }

    json_ok(['url'=>$relUrl, 'filename'=>$name]);
}
