<?php
// diagnose_real_problem.php - Identifica o VERDADEIRO problema

header('Content-Type: text/html; charset=utf-8');

$conn = new PDO('mysql:host=localhost;dbname=digupdog_FEED;charset=utf8mb4', 
                'digupdog_FEEDadmin', 'Raimundinho1');

?>
<!DOCTYPE html>
<html>
<head>
    <title>Diagnóstico Final - Problema Real</title>
    <style>
        body { font-family: Arial; margin: 20px; }
        .good { background: #d4edda; padding: 10px; margin: 10px 0; }
        .bad { background: #f8d7da; padding: 10px; margin: 10px 0; }
        .warning { background: #fff3cd; padding: 10px; margin: 10px 0; }
        .sql { background: #f0f0f0; padding: 10px; font-family: monospace; }
        table { border-collapse: collapse; width: 100%; margin: 10px 0; }
        td, th { border: 1px solid #ddd; padding: 8px; }
    </style>
</head>
<body>

<h1>🔍 Diagnóstico Final do Problema de Performance</h1>

<div class="good">
    <h2>✅ Tabela pinfeeds está OK!</h2>
    <p>Você já tem o índice <code>idx_id_desc</code> que é o mais importante.</p>
</div>

<?php
// 1. Verifica índices em COMMENTS (provavelmente o problema)
echo "<h2>1. Verificando tabela COMMENTS:</h2>";
$indexes = $conn->query("SHOW INDEX FROM comments")->fetchAll();
$has_feed_index = false;

echo "<table>";
echo "<tr><th>Índice</th><th>Coluna</th><th>Status</th></tr>";
foreach ($indexes as $idx) {
    echo "<tr>";
    echo "<td>{$idx['Key_name']}</td>";
    echo "<td>{$idx['Column_name']}</td>";
    if ($idx['Column_name'] == 'feed_id') {
        $has_feed_index = true;
        echo "<td style='color:green'>✓ OK</td>";
    } else {
        echo "<td>-</td>";
    }
    echo "</tr>";
}
echo "</table>";

if (!$has_feed_index) {
    echo "<div class='bad'>";
    echo "<strong>❌ PROBLEMA ENCONTRADO!</strong> Falta índice em comments.feed_id<br>";
    echo "Isso torna a contagem de comentários MUITO lenta!";
    echo "</div>";
}

// 2. Verifica índices em FAVORITES
echo "<h2>2. Verificando tabela FAVORITES:</h2>";
$indexes = $conn->query("SHOW INDEX FROM favorites")->fetchAll();
$has_user_feed_index = false;

foreach ($indexes as $idx) {
    if ($idx['Column_name'] == 'user_id' || $idx['Column_name'] == 'feed_id') {
        $has_user_feed_index = true;
    }
}

if (!$has_user_feed_index) {
    echo "<div class='warning'>⚠️ Falta índice composto em favorites(user_id, feed_id)</div>";
} else {
    echo "<div class='good'>✓ Índices OK</div>";
}

// 3. Verifica índices em LIKES_DISLIKES
echo "<h2>3. Verificando tabela LIKES_DISLIKES:</h2>";
$indexes = $conn->query("SHOW INDEX FROM likes_dislikes")->fetchAll();
$has_user_feed_index = false;

foreach ($indexes as $idx) {
    if ($idx['Column_name'] == 'user_id' || $idx['Column_name'] == 'feed_id') {
        $has_user_feed_index = true;
    }
}

if (!$has_user_feed_index) {
    echo "<div class='warning'>⚠️ Falta índice composto em likes_dislikes(user_id, feed_id)</div>";
} else {
    echo "<div class='good'>✓ Índices OK</div>";
}

// 4. O GRANDE VILÃO
echo "<h2>4. O GRANDE PROBLEMA - title_description_index:</h2>";
$count = $conn->query("SELECT COUNT(*) FROM title_description_index")->fetchColumn();
echo "<div class='bad'>";
echo "<h3>❌ ESTE É O PROBLEMA PRINCIPAL!</h3>";
echo "<p>A tabela title_description_index tem <strong>" . number_format($count) . "</strong> registros!</p>";
echo "<p>Qualquer query que use JOIN com essa tabela será EXTREMAMENTE lenta.</p>";
echo "</div>";

// 5. Teste de performance
echo "<h2>5. Testes de Performance:</h2>";

// Teste 1: Query simples
$start = microtime(true);
$conn->query("SELECT * FROM pinfeeds ORDER BY id DESC LIMIT 21")->fetchAll();
$time1 = round((microtime(true) - $start) * 1000, 2);
echo "<p>✓ Query simples (sem JOIN): <strong>{$time1}ms</strong></p>";

// Teste 2: Query com subquery de comments
$start = microtime(true);
$conn->query("
    SELECT *, (SELECT COUNT(*) FROM comments WHERE feed_id = pinfeeds.id) as comment_count 
    FROM pinfeeds 
    ORDER BY id DESC 
    LIMIT 21
")->fetchAll();
$time2 = round((microtime(true) - $start) * 1000, 2);
echo "<p>" . ($time2 > 500 ? "❌" : "✓") . " Query com contagem de comentários: <strong>{$time2}ms</strong></p>";

// Teste 3: Query com title_description_index
$start = microtime(true);
$conn->query("
    SELECT DISTINCT f.* 
    FROM pinfeeds f
    JOIN title_description_index tdi ON f.id = tdi.feed_id
    WHERE tdi.word = 'test'
    LIMIT 21
")->fetchAll();
$time3 = round((microtime(true) - $start) * 1000, 2);
echo "<p>❌ Query com title_description_index: <strong>{$time3}ms</strong> (MUITO LENTO!)</p>";

// SOLUÇÃO
echo "<h2>🔧 SOLUÇÃO DEFINITIVA:</h2>";

echo "<div class='good'>";
echo "<h3>Execute APENAS estes comandos SQL:</h3>";
echo "<div class='sql'>";

if (!$has_feed_index) {
    echo "-- CRÍTICO: Índice para comentários<br>";
    echo "ALTER TABLE comments ADD INDEX idx_feed_id (feed_id);<br><br>";
}

echo "-- OPCIONAL: Índices adicionais<br>";
echo "ALTER TABLE favorites ADD INDEX idx_user_feed (user_id, feed_id);<br>";
echo "ALTER TABLE likes_dislikes ADD INDEX idx_user_feed (user_id, feed_id);<br><br>";

echo "-- ANALISE as tabelas após criar os índices<br>";
echo "ANALYZE TABLE comments, favorites, likes_dislikes;<br>";
echo "</div>";
echo "</div>";

echo "<div class='warning'>";
echo "<h3>E use o arquivo get_pinfeeds_production.php que:</h3>";
echo "<ul>";
echo "<li>✅ EVITA completamente a tabela title_description_index de 746M registros</li>";
echo "<li>✅ Usa cache agressivo de 5 minutos</li>";
echo "<li>✅ Comprime respostas com GZIP</li>";
echo "<li>✅ Para buscas, usa LIKE direto nas colunas (mais rápido)</li>";
echo "</ul>";
echo "</div>";

// Estatísticas finais
echo "<h2>📊 Estatísticas do Banco:</h2>";
echo "<table>";
echo "<tr><th>Tabela</th><th>Registros</th><th>Tamanho</th></tr>";

$stats = $conn->query("
    SELECT TABLE_NAME, TABLE_ROWS, 
           ROUND((DATA_LENGTH + INDEX_LENGTH) / 1024 / 1024, 2) as SIZE_MB
    FROM information_schema.TABLES 
    WHERE TABLE_SCHEMA = 'digupdog_FEED'
    ORDER BY TABLE_ROWS DESC
    LIMIT 10
")->fetchAll();

foreach ($stats as $stat) {
    $class = $stat['TABLE_ROWS'] > 100000000 ? 'style="background:#ffcccc"' : '';
    echo "<tr $class>";
    echo "<td>{$stat['TABLE_NAME']}</td>";
    echo "<td>" . number_format($stat['TABLE_ROWS']) . "</td>";
    echo "<td>{$stat['SIZE_MB']} MB</td>";
    echo "</tr>";
}
echo "</table>";
?>

<h2>✅ Resumo Final:</h2>
<div style="background: #e8f5e9; padding: 20px; border-radius: 10px;">
    <ol>
        <li><strong>Use get_pinfeeds_production.php</strong> - evita a tabela de 746M registros</li>
        <li><strong>Crie o índice em comments</strong> (se não existir) - crítico para performance</li>
        <li><strong>O problema NÃO é a tabela pinfeeds</strong> - você já tem os índices certos</li>
        <li><strong>O problema É a tabela title_description_index</strong> - 746M registros!</li>
    </ol>
</div>

</body>
</html>