<?php
session_start();

// Conexão com o Banco de Dados
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Erro na conexão com o banco de dados: " . $conn->connect_error);
}
$conn->set_charset($charset);

// Função para processar o follow/unfollow
function processFollow($conn, $userId, $followType, $followValue, $action) {
    if ($action === 'follow') {
        // Verifica se já está seguindo
        $stmt = $conn->prepare("SELECT id FROM follows WHERE user_id = ? AND follow_type = ? AND follow_value = ?");
        $stmt->bind_param("iss", $userId, $followType, $followValue);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 0) {
            // Inserir o follow
            $stmt = $conn->prepare("INSERT INTO follows (user_id, follow_type, follow_value) VALUES (?, ?, ?)");
            $stmt->bind_param("iss", $userId, $followType, $followValue);
            if ($stmt->execute()) {
                return json_encode(['status' => 'success', 'message' => 'Seguido com sucesso']);
            } else {
                return json_encode(['status' => 'error', 'message' => 'Erro ao seguir']);
            }
        } else {
            return json_encode(['status' => 'error', 'message' => 'Já está seguindo']);
        }
    } elseif ($action === 'unfollow') {
        // Deixar de seguir
        $stmt = $conn->prepare("DELETE FROM follows WHERE user_id = ? AND follow_type = ? AND follow_value = ?");
        $stmt->bind_param("iss", $userId, $followType, $followValue);
        if ($stmt->execute()) {
            return json_encode(['status' => 'success', 'message' => 'Deixou de seguir']);
        } else {
            return json_encode(['status' => 'error', 'message' => 'Erro ao deixar de seguir']);
        }
    }
    return json_encode(['status' => 'error', 'message' => 'Ação inválida']);
}

// Processa requisição POST (seguir ou deixar de seguir)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_SESSION['user_id'])) {
        echo json_encode(['status' => 'error', 'message' => 'Usuário não está logado']);
        exit();
    }

    $userId = $_SESSION['user_id'];
    $followType = $_POST['follow_type'] ?? null;
    $followValue = $_POST['follow_value'] ?? null;
    $action = $_POST['action'] ?? null;

    if (!$followType || !$followValue || !$action) {
        echo json_encode(['status' => 'error', 'message' => 'Dados incompletos']);
        exit();
    }

    echo processFollow($conn, $userId, $followType, $followValue, $action);
}

// Função para verificar o estado de follow
function checkFollowStatus($conn, $userId, $followType, $followValue) {
    $stmt = $conn->prepare("SELECT id FROM follows WHERE user_id = ? AND follow_type = ? AND follow_value = ?");
    $stmt->bind_param("iss", $userId, $followType, $followValue);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        return json_encode(['status' => 'following']);
    } else {
        return json_encode(['status' => 'not_following']);
    }
}

// Processa requisição GET (verificar estado de follow)
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (!isset($_SESSION['user_id'])) {
        echo json_encode(['status' => 'error', 'message' => 'Usuário não está logado']);
        exit();
    }

    $userId = $_SESSION['user_id'];
    $followType = $_GET['follow_type'] ?? null;
    $followValue = $_GET['follow_value'] ?? null;

    if (!$followType || !$followValue) {
        echo json_encode(['status' => 'error', 'message' => 'Dados incompletos']);
        exit();
    }

    echo checkFollowStatus($conn, $userId, $followType, $followValue);
}

$conn->close();
?>