<?php
// test_connection.php - Testa a conexão com o banco

header('Content-Type: text/html; charset=utf-8');

echo "<h1>Teste de Conexão MySQL</h1>";

// Configurações
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

echo "<h2>1. Testando com PDO (mesmo método do arquivo original):</h2>";
try {
    $conn = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "<p style='color:green'>✓ Conexão PDO bem sucedida!</p>";
    
    // Testa uma query simples
    $result = $conn->query("SELECT COUNT(*) as total FROM pinfeeds")->fetch();
    echo "<p>Total de registros em pinfeeds: " . number_format($result['total']) . "</p>";
    
} catch (PDOException $e) {
    echo "<p style='color:red'>✗ Erro PDO: " . $e->getMessage() . "</p>";
    echo "<p>Código do erro: " . $e->getCode() . "</p>";
}

echo "<h2>2. Testando com mysqli (método alternativo):</h2>";
$mysqli = @new mysqli($host, $user, $pass, $db);

if ($mysqli->connect_error) {
    echo "<p style='color:red'>✗ Erro mysqli: " . $mysqli->connect_error . "</p>";
} else {
    echo "<p style='color:green'>✓ Conexão mysqli bem sucedida!</p>";
    $mysqli->close();
}

echo "<h2>3. Verificando configurações PHP:</h2>";
echo "<p>PHP Version: " . phpversion() . "</p>";
echo "<p>PDO MySQL disponível: " . (extension_loaded('pdo_mysql') ? 'Sim' : 'Não') . "</p>";
echo "<p>MySQLi disponível: " . (extension_loaded('mysqli') ? 'Sim' : 'Não') . "</p>";

echo "<h2>4. Possíveis soluções:</h2>";
echo "<ul>";
echo "<li>Verifique se o MySQL está rodando: <code>sudo service mysql status</code></li>";
echo "<li>Verifique as credenciais no arquivo</li>";
echo "<li>Tente usar 127.0.0.1 em vez de localhost</li>";
echo "<li>Verifique se o usuário tem permissões: <code>GRANT ALL ON digupdog_FEED.* TO 'digupdog_FEEDadmin'@'localhost';</code></li>";
echo "</ul>";

// Testa com diferentes hosts
echo "<h2>5. Testando diferentes hosts:</h2>";
$hosts_to_test = ['localhost', '127.0.0.1', '::1'];

foreach ($hosts_to_test as $test_host) {
    try {
        $test_conn = new PDO("mysql:host=$test_host;dbname=$db;charset=$charset", $user, $pass);
        echo "<p style='color:green'>✓ Host '$test_host' funciona!</p>";
        $test_conn = null;
    } catch (PDOException $e) {
        echo "<p style='color:red'>✗ Host '$test_host' falhou</p>";
    }
}
?>