<?php
require_once __DIR__ . '/../config.php';

// api_author_profile.php
session_start();
header('Content-Type: application/json; charset=utf-8');

$host = 'localhost';
$db   = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    echo json_encode(['success'=>false, 'error'=>'db']); exit;
}

$author = isset($_GET['author']) ? trim($_GET['author']) : '';
if ($author === '') { echo json_encode(['success'=>false, 'error'=>'missing_author']); exit; }

$profile = [
  'success'    => true,
  'author'     => $author,
  'posts'      => 0,
  'followers'  => 0,
  'likes'      => 0,
  'dislikes'   => 0,
  'comments'   => 0,
  'shares'     => 0,
  'last_post'  => null,
  'is_following' => false
];

try {
  // posts & last post
  $stmt = $pdo->prepare("SELECT COUNT(*) AS c, MAX(pubDate) AS lastd FROM pinfeeds WHERE author = :a");
  $stmt->execute([':a'=>$author]);
  if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $profile['posts'] = (int)$row['c'];
    $profile['last_post'] = $row['lastd'];
  }

  // followers (users following this author)
  $stmt = $pdo->prepare("SELECT COUNT(*) FROM follows WHERE follow_type='author' AND follow_value=:a");
  $stmt->execute([':a'=>$author]);
  $profile['followers'] = (int)$stmt->fetchColumn();

  // is current user following?
  if (isset($_SESSION['username'])) {
    $stmt = $pdo->prepare("SELECT ID FROM user_myhashtag WHERE username = :u LIMIT 1");
    $stmt->execute([':u'=>$_SESSION['username']]);
    $uid = ($row = $stmt->fetch(PDO::FETCH_ASSOC)) ? (int)$row['ID'] : null;
    if ($uid) {
      $stmt = $pdo->prepare("SELECT 1 FROM follows WHERE user_id=:u AND follow_type='author' AND follow_value=:a LIMIT 1");
      $stmt->execute([':u'=>$uid, ':a'=>$author]);
      $profile['is_following'] = (bool)$stmt->fetchColumn();
    }
  }

  // aggregates from feed_counters if it exists
  $hasCounters = false;
  try {
    $pdo->query("SELECT 1 FROM feed_counters LIMIT 1");
    $hasCounters = true;
  } catch (\Throwable $t) { $hasCounters = false; }

  if ($hasCounters) {
    $sql = "SELECT 
              SUM(fc.like_count)     AS likes,
              SUM(fc.dislike_count)  AS dislikes,
              SUM(fc.comment_count)  AS comments,
              SUM(fc.share_count)    AS shares
            FROM feed_counters fc
            JOIN pinfeeds f ON f.id = fc.feed_id
            WHERE f.author = :a";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':a'=>$author]);
    if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
      $profile['likes']    = (int)($row['likes'] ?? 0);
      $profile['dislikes'] = (int)($row['dislikes'] ?? 0);
      $profile['comments'] = (int)($row['comments'] ?? 0);
      $profile['shares']   = (int)($row['shares'] ?? 0);
    }
  }
} catch (\Throwable $e) {
  // keep success true; just leave defaults
}

echo json_encode($profile);
