<?php
require_once __DIR__ . '/../config.php';

//api_follow_sets.php
session_start();
header('Content-Type: application/json; charset=utf-8');

$host = 'localhost';
$db   = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    echo json_encode(['success'=>false, 'error'=>'db']); exit;
}

function getUserId(PDO $pdo): ?int {
    if (!isset($_SESSION['username'])) return null;
    $st = $pdo->prepare("SELECT ID FROM user_myhashtag WHERE username = :u LIMIT 1");
    $st->execute([':u' => $_SESSION['username']]);
    $r = $st->fetch(PDO::FETCH_ASSOC);
    return $r ? (int)$r['ID'] : null;
}

$userId = getUserId($pdo);
if (!$userId) { echo json_encode(['success'=>true,'tags'=>[],'source_domains'=>[],'authors'=>[]]); exit; }

$st = $pdo->prepare("SELECT follow_type, follow_value FROM follows WHERE user_id = :uid");
$st->execute([':uid'=>$userId]);

$tags=[]; $src=[]; $auth=[];
while($row = $st->fetch(PDO::FETCH_ASSOC)){
    $val = trim($row['follow_value']);
    if ($row['follow_type']==='tag') $tags[] = $val;
    elseif ($row['follow_type']==='source_domain') $src[] = $val;
    elseif ($row['follow_type']==='author') $auth[] = $val;
}
echo json_encode(['success'=>true, 'tags'=>$tags, 'source_domains'=>$src, 'authors'=>$auth]);
