<?php
require_once __DIR__ . '/../config.php';

/**
 * =========================================================
 *  File: api_link_og.php
 *  Purpose: Retornar OG metadata (title, description, image) com cache.
 *  Input:  GET url
 *  Output: { success: true, title: "...", description: "...", image: "..." }
 * =========================================================
 */
header('Content-Type: application/json; charset=utf-8');

$host = 'localhost';
$db   = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

try {
  $pdo = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
  ]);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['success'=>false,'error'=>'db_connection_failed']); exit;
}

$url = isset($_GET['url']) ? trim($_GET['url']) : '';
if ($url === '' || !preg_match('~^https?://~i', $url)) {
  echo json_encode(['success'=>false,'error'=>'invalid_url']); exit;
}

function fetch_url_body(string $url): array {
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_MAXREDIRS => 4,
    CURLOPT_TIMEOUT => 7,
    CURLOPT_USERAGENT => 'Mozilla/5.0 (compatible; MyHashtagBot/1.0; +https://myhashtag.io)'
  ]);
  $body = curl_exec($ch);
  $ctype = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
  curl_close($ch);
  return [$body, $ctype];
}
function absolutize_url(string $base, string $maybe): string {
  if (!$maybe) return '';
  if (preg_match('~^https?://~i', $maybe)) return $maybe;
  $p = parse_url($base);
  if (!$p || empty($p['scheme']) || empty($p['host'])) return $maybe;
  $origin = $p['scheme'].'://'.$p['host'].(isset($p['port'])?':'.$p['port']:'');
  if ($maybe[0] === '/') return $origin.$maybe;
  $path = isset($p['path']) ? $p['path'] : '/';
  $dir  = rtrim(preg_replace('~/[^/]*$~','/',$path),'/');
  return $origin.$dir.'/'.$maybe;
}
function parse_og_all(string $html): array {
  $out = ['title'=>'','description'=>'','image'=>''];
  if (preg_match('~<meta[^>]+property=["\']og:title["\'][^>]*content=["\']([^"\']+)["\']~i', $html, $m)) $out['title'] = $m[1];
  if (!$out['title'] && preg_match('~<title[^>]*>(.*?)</title>~is', $html, $m)) $out['title'] = trim($m[1]);
  if (preg_match('~<meta[^>]+property=["\']og:description["\'][^>]*content=["\']([^"\']+)["\']~i', $html, $m)) $out['description'] = $m[1];
  if (!$out['description'] && preg_match('~<meta[^>]+name=["\']description["\'][^>]*content=["\']([^"\']+)["\']~i', $html, $m)) $out['description'] = $m[1];
  if (preg_match('~<meta[^>]+property=["\']og:image["\'][^>]*content=["\']([^"\']+)["\']~i', $html, $m)) $out['image'] = $m[1];
  if (!$out['image'] && preg_match('~<meta[^>]+name=["\']twitter:image["\'][^>]*content=["\']([^"\']+)["\']~i', $html, $m)) $out['image'] = $m[1];
  return $out;
}

/* cache */
$hash = sha1($url);
$st = $pdo->prepare("SELECT title, description, image FROM link_og_cache WHERE url_hash = ? LIMIT 1");
$st->execute([$hash]);
$row = $st->fetch();
if ($row && ($row['title'] || $row['description'] || $row['image'])) {
  echo json_encode(['success'=>true,'title'=>$row['title'],'description'=>$row['description'],'image'=>$row['image']]); exit;
}

/* fetch */
list($body,$ctype) = fetch_url_body($url);
if (!$body || stripos((string)$ctype, 'text/html') === false) {
  echo json_encode(['success'=>false,'error'=>'unfetchable']); exit;
}
$body = @mb_convert_encoding($body, 'UTF-8', mb_detect_encoding($body, 'UTF-8, ISO-8859-1, Windows-1252', true) ?: 'UTF-8');
$og = parse_og_all($body);
$og['image'] = absolutize_url($url, $og['image']);

/* salva cache */
try{
  $up = $pdo->prepare("INSERT INTO link_og_cache (url_hash, url, title, description, image, fetched_at)
    VALUES (:h,:u,:t,:d,:i,NOW())
    ON DUPLICATE KEY UPDATE title=VALUES(title), description=VALUES(description), image=VALUES(image), fetched_at=NOW()");
  $up->execute([':h'=>$hash, ':u'=>$url, ':t'=>$og['title'], ':d'=>$og['description'], ':i'=>$og['image']]);
}catch(Throwable $e){}

echo json_encode(['success'=>true,'title'=>$og['title'],'description'=>$og['description'],'image'=>$og['image']]); exit;
