<?php
require_once __DIR__ . '/../config.php';

session_start();
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store');

$host='localhost'; $db='digupdog_FEED'; $user='digupdog_FEEDadmin'; $pass='Raimundinho1'; $charset='utf8mb4';
try{
  $pdo=new PDO("mysql:host=$host;dbname=$db;charset=$charset",$user,$pass,[PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC]);
}catch(PDOException $e){ echo json_encode(['success'=>false]); exit; }

$pdo->exec("CREATE TABLE IF NOT EXISTS feed_share_counters (
  feed_id INT NOT NULL PRIMARY KEY,
  share_count INT NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';

if($method==='GET'){
  $id = (int)($_GET['feed_id'] ?? 0);
  if($id<=0){ echo json_encode(['success'=>false]); exit; }
  $st = $pdo->prepare("SELECT share_count FROM feed_share_counters WHERE feed_id=?");
  $st->execute([$id]);
  $n = (int)($st->fetchColumn() ?: 0);
  echo json_encode(['success'=>true,'share_count'=>$n]); exit;
}
if($method==='POST'){
  $in = json_decode(file_get_contents('php://input'), true) ?: [];
  $id = (int)($in['feed_id'] ?? 0);
  $delta = isset($in['delta']) ? (int)$in['delta'] : 1;
  if($id<=0){ echo json_encode(['success'=>false]); exit; }
  $pdo->prepare("INSERT INTO feed_share_counters (feed_id, share_count) VALUES (?,0) ON DUPLICATE KEY UPDATE share_count=share_count")->execute([$id]);
  $pdo->prepare("UPDATE feed_share_counters SET share_count = GREATEST(0, share_count + ?) WHERE feed_id=?")->execute([$delta, $id]);
  $st = $pdo->prepare("SELECT share_count FROM feed_share_counters WHERE feed_id=?"); $st->execute([$id]);
  $n = (int)($st->fetchColumn() ?: 0);
  echo json_encode(['success'=>true,'share_count'=>$n]); exit;
}

http_response_code(405);
echo json_encode(['success'=>false]);
