# FLOWB0T NEXUS - Deployment Guide

## Server Information
- **Server:** 159-100-13-177.cprapid.com
- **SSH Port:** 22
- **Username:** root
- **Password:** Squatting-Refund1-Quantum
- **Target Directory:** /home/digupdog/public_html/flowb0t.com/nexus/

## Database Information
- **Host:** localhost
- **Port:** 3306
- **Database:** digupdog_FEED
- **Username:** digupdog_FEEDadmin
- **Password:** Raimundinho1

---

## Step 1: Connect to Server via SSH

```bash
ssh root@159-100-13-177.cprapid.com -p 22
# Password: Squatting-Refund1-Quantum
```

## Step 2: Create Directory Structure

```bash
cd /home/digupdog/public_html/flowb0t.com

# Create main nexus directory
mkdir -p nexus

# Create all subdirectories
mkdir -p nexus/config
mkdir -p nexus/core
mkdir -p nexus/engine/SearchProviders
mkdir -p nexus/engine/Processors
mkdir -p nexus/engine/Workers
mkdir -p nexus/engine/Filters
mkdir -p nexus/models
mkdir -p nexus/api
mkdir -p nexus/ui/assets/css
mkdir -p nexus/ui/assets/js
mkdir -p nexus/ui/assets/img
mkdir -p nexus/ui/components
mkdir -p nexus/ui/pages
mkdir -p nexus/cli
mkdir -p nexus/data
mkdir -p nexus/logs/app
mkdir -p nexus/logs/crawl
mkdir -p nexus/logs/error
mkdir -p nexus/logs/access
mkdir -p nexus/exports
mkdir -p nexus/temp
mkdir -p nexus/sql
```

## Step 3: Set Permissions

```bash
chmod -R 755 /home/digupdog/public_html/flowb0t.com/nexus
chmod -R 777 /home/digupdog/public_html/flowb0t.com/nexus/logs
chmod -R 777 /home/digupdog/public_html/flowb0t.com/nexus/exports
chmod -R 777 /home/digupdog/public_html/flowb0t.com/nexus/temp

# Protect .env file
chmod 600 /home/digupdog/public_html/flowb0t.com/nexus/.env
```

## Step 4: Upload Files

Use FTP/SFTP or copy files manually. Upload the entire contents of `flowb0t-nexus/` to `/home/digupdog/public_html/flowb0t.com/nexus/`

### Files to Upload:
```
nexus/
├── index.php
├── .env
├── .htaccess
├── core/
│   ├── Database.php
│   └── Logger.php
├── engine/
│   ├── CrawlerEngine.php
│   ├── SearchProviders/
│   │   └── BingProvider.php
│   └── Processors/
│       └── ImportProcessor.php
├── data/
│   └── authors.php
├── api/
│   └── ajax_handler.php
├── ui/
│   └── pages/
│       ├── dashboard.php
│       ├── new-job.php
│       ├── jobs.php
│       ├── job-detail.php
│       ├── results.php
│       ├── exports.php
│       ├── logs.php
│       └── settings.php
└── sql/
    ├── schema.sql
    └── check_existing_tables.sql
```

## Step 5: Create Database Tables

Connect to MySQL and run the schema:

```bash
mysql -u digupdog_FEEDadmin -p digupdog_FEED
# Password: Raimundinho1
```

Then run the SQL from `sql/schema.sql`:

```sql
-- Run each CREATE TABLE statement from schema.sql
-- This creates the nexus_* tables for job management
-- Does NOT modify existing pinfeeds, feed_data, user_myhashtag tables
```

## Step 6: Verify Installation

1. Open browser: `https://flowb0t.com/nexus/`
2. You should see the FLOWB0T NEXUS dashboard
3. Check that statistics are loading (if tables exist)

## Step 7: Test Database Connection

1. Go to Settings page
2. Click "Test DB Connection"
3. Should show "Connection OK"

## Step 8: Create First Job (Test)

1. Click "New Job"
2. Enter a test name
3. Add a single search term: "test news"
4. Set Max Pages to 10
5. Click "Start Crawl Job"

---

## Troubleshooting

### Error: "Table doesn't exist"
Run the SQL schema from `sql/schema.sql` to create the nexus_* tables.

### Error: "Permission denied"
```bash
chmod -R 755 /home/digupdog/public_html/flowb0t.com/nexus
chown -R digupdog:digupdog /home/digupdog/public_html/flowb0t.com/nexus
```

### Error: "Database connection failed"
Check `.env` file has correct credentials:
- DB_HOST=localhost
- DB_NAME=digupdog_FEED
- DB_USER=digupdog_FEEDadmin
- DB_PASS=Raimundinho1

### Page shows blank/500 error
Check PHP error logs:
```bash
tail -f /home/digupdog/logs/error.log
```

---

## Quick Deploy Commands (All-in-one)

```bash
# SSH into server
ssh root@159-100-13-177.cprapid.com -p 22

# Create all directories
cd /home/digupdog/public_html/flowb0t.com
mkdir -p nexus/{config,core,engine/SearchProviders,engine/Processors,engine/Workers,engine/Filters,models,api,ui/assets/css,ui/assets/js,ui/assets/img,ui/components,ui/pages,cli,data,logs/app,logs/crawl,logs/error,logs/access,exports,temp,sql}

# Set permissions
chmod -R 755 nexus
chmod -R 777 nexus/{logs,exports,temp}

# Verify structure
ls -la nexus/
```

---

## Cron Jobs (Optional - for background processing)

Add to crontab (`crontab -e`):

```bash
# Run crawler worker every minute
* * * * * /usr/bin/php /home/digupdog/public_html/flowb0t.com/nexus/cli/worker.php >> /dev/null 2>&1

# Cleanup old data daily at 3 AM
0 3 * * * /usr/bin/php /home/digupdog/public_html/flowb0t.com/nexus/cli/cleanup.php >> /dev/null 2>&1
```

---

## Access URL

**FLOWB0T NEXUS:** https://flowb0t.com/nexus/

---

## Support

If you encounter issues:
1. Check PHP error logs
2. Verify database connection
3. Ensure all files are uploaded
4. Check file permissions
