<?php
/**
 * ===========================================
 * FLOWBOT DCI - AUTHOR GENERATOR
 * ===========================================
 * Generates random author names
 */

declare(strict_types=1);

namespace FlowbotDCI\Utils;

class AuthorGenerator
{
    private array $firstNames = [
        // English
        "John", "Jane", "Michael", "Emily", "David", "Sarah", "William", "Olivia",
        "James", "Sophia", "Daniel", "Isabella", "Matthew", "Ava", "Ethan", "Mia",
        "Alexander", "Amelia", "Benjamin", "Harper", "Henry", "Ella", "Joseph",
        "Abigail", "Samuel", "Grace", "Jackson", "Scarlett", "Chloe", "Evelyn",

        // International
        "Andre", "Isabelle", "Carlos", "Mariana", "Luis", "Ana", "Pedro", "Juliana",
        "Hans", "Elke", "Arjun", "Priyanka", "Hiroshi", "Yuki", "Aditya", "Aisha",
        "Dimitri", "Natalia", "Yusuf", "Fatima", "Kwame", "Amina", "Chen", "Ling",
        "Jorge", "Carmen", "Sebastian", "Camila", "Thiago", "Beatriz", "Igor",
        "Svetlana", "Mikhail", "Anastasia", "Sergio", "Paloma", "Lee", "Sook",

        // Creative/Modern
        "MoonlightKnight", "SunshineQueen", "RedDragon", "BluePhoenix",
        "ShadowHunter", "StarGazer", "ThunderStriker", "CrystalDreamer",
        "SilverWolf", "GoldStar", "LoneRanger", "MysticRose",
    ];

    private array $lastNames = [
        // English
        "Smith", "Johnson", "Williams", "Brown", "Jones", "Garcia", "Miller",
        "Davis", "Rodriguez", "Martinez", "Hernandez", "Lopez", "Gonzalez",
        "Wilson", "Anderson", "Thomas", "Taylor", "Moore", "Jackson", "Martin",

        // International
        "Silva", "Santos", "Oliveira", "Souza", "Costa", "Pereira", "Ferreira",
        "Muller", "Schmidt", "Schneider", "Fischer", "Weber", "Meyer", "Wagner",
        "Patel", "Sharma", "Kumar", "Singh", "Gupta", "Shah", "Tanaka", "Yamamoto",
        "Kim", "Lee", "Park", "Choi", "Chen", "Wang", "Li", "Zhang",

        // Creative
        "Skywalker", "Nightingale", "Stormborn", "Shadowmend", "Lightbringer",
        "Ironforge", "Dawnbreaker", "Frostweaver", "Sunfire", "Moonshadow",
    ];

    /**
     * Generate random author name
     */
    public function generate(): string
    {
        $firstName = $this->firstNames[array_rand($this->firstNames)];
        $lastName = $this->lastNames[array_rand($this->lastNames)];

        return "$firstName $lastName";
    }

    /**
     * Generate multiple unique authors
     */
    public function generateMultiple(int $count): array
    {
        $authors = [];
        $attempts = 0;
        $maxAttempts = $count * 10;

        while (count($authors) < $count && $attempts < $maxAttempts) {
            $author = $this->generate();
            if (!in_array($author, $authors)) {
                $authors[] = $author;
            }
            $attempts++;
        }

        return $authors;
    }

    /**
     * Add custom first names
     */
    public function addFirstNames(array $names): self
    {
        $this->firstNames = array_merge($this->firstNames, $names);
        return $this;
    }

    /**
     * Add custom last names
     */
    public function addLastNames(array $names): self
    {
        $this->lastNames = array_merge($this->lastNames, $names);
        return $this;
    }

    /**
     * Get first name only
     */
    public function getFirstName(): string
    {
        return $this->firstNames[array_rand($this->firstNames)];
    }

    /**
     * Get last name only
     */
    public function getLastName(): string
    {
        return $this->lastNames[array_rand($this->lastNames)];
    }
}
