<?php
//index.php
// Configurações de segurança da sessão - devem ser definidas antes de session_start()
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 1); // Use apenas se o site estiver usando HTTPS

session_start(); // Sessão iniciada aqui, depois das configurações

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Conexão com o Banco de Dados
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

// Configura a conexão para usar o charset correto
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Erro na conexão com o banco de dados: " . $conn->connect_error);
}

// Define o charset para utf8mb4
$conn->set_charset("utf8mb4");

// Função para obter avatar do autor
function getAuthorAvatarByUsername($username, $conn) {
    $stmt = $conn->prepare("SELECT thumbnail FROM pinfeeds WHERE author = ? ORDER BY pubDate DESC LIMIT 1");
    $stmt->bind_param("s", $username); // "s" indica que o parâmetro é uma string
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        return $row['thumbnail'];
    } else {
        return false;
    }
}

// Parte para exibir tags
$tagsFile = 'tags.json';
$tags = file_exists($tagsFile) ? json_decode(file_get_contents($tagsFile), true) : [];
shuffle($tags); // Embaralha as tags
$randomTags = array_slice($tags, 0, 12); // Pega 12 tags aleatórias
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:site" content="@nomeDoSeuSite">
    <meta name="twitter:title" content="Título da Página">
    <meta name="twitter:description" content="Descrição da Página">
    <meta name="twitter:image" content="URL_da_Imagem">

    <title>DigUpDOG.com</title>
    <meta id="base-url" content="https://digupdog.com/">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
    <link href="styles.css" rel="stylesheet" type="text/css">
    <!-- Scripts Externos -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script async src="https://static.addtoany.com/menu/page.js"></script>
</head>
<body>

<div class="header-content">
    <div class="search-bar">
        <button class="home-button"><i class="fas fa-hashtag"></i></button>
        <button class="menu-button"><i class="fas fa-bars menu-icon"></i></button>
        <!-- Campo de busca com suporte a todos os caracteres -->
        <input id="search-query" placeholder="#..." type="text" onclick="clearInput()" />
        <button id="search-button">
            <i class="fas fa-search search-icon"></i>
            <span id="loading-spinner" style="display:none;"><i class="fas fa-spinner fa-spin"></i></span>
        </button>
        <a class="button pin" id="addPinButton" href="https://digupdog.com/aaa1.php" target="_self"><i class="fas fa-plus"></i></a>
        <a class="category-button plus" href="https://digupdog.com/plus.php" target="_self">18+</a>
    </div>
    
    <div id="side-menu" class="side-menu">
        <!-- Conteúdo do menu aqui -->
        <a href="#">Link 1</a>
        <a href="#">Link 2</a>
        <!-- Mais links do menu -->
    </div>

    <!-- Overlay -->
    <div class="overlay"></div>

    <div class="category-buttons-container">
        <div class="category-buttons">
            <div class="left-arrow"></div>
            <div class="category-buttons-wrapper">
                <!-- Tags Container -->
                <div id="tags-container" style="margin-top: 2px;">
                    <?php foreach ($randomTags as $tag): ?>
                        <a href="#" class="tag-link tag-search-link" data-tag="<?php echo htmlspecialchars($tag); ?>">#<?php echo htmlspecialchars($tag); ?></a>
                    <?php endforeach; ?>
                    <a href="#" id="reload-tags" title="Recarregar tags"><i class="fas fa-sync-alt"></i></a>
                </div>
            </div>
            <div class="right-arrow"></div>
        </div>
    </div>

    <!-- Login/Register Section or Welcome Message -->
    <div class="container"></div>
    <div class="login-register-section" id="loginSection">
        <?php
        // Verifica se o usuário está logado
        if (isset($_SESSION['username'])) {
            $username = htmlspecialchars($_SESSION['username']);
            $authorAvatar = getAuthorAvatarByUsername($username, $conn);
            echo "<a href='perfil.php?autor=$username'>";
            if ($authorAvatar !== false) {
                echo "<img src='$authorAvatar' alt='Avatar' class='author-avatar' style='width: 20px; height: 20px; margin-right: 5px; border: 2px solid black; border-radius: 20px; vertical-align: middle;'>";
            }
            echo "@" . $username . "</a>"; // Adicionando "@" antes do nome do usuário
            echo "<a href='logout.php'><i class='fas fa-sign-out-alt'></i></a>";
        } else {
            // Usuário não está logado
            echo "<a href='login.html'><i class='fas fa-sign-in-alt'></i></a>";
            echo "<a href='register.html'><i class='fas fa-user-plus'></i></a>";
        }
        ?>
    </div>
</div>

<div id="follow-popup"></div>

<!-- Adicionando o GIF de like -->
<div id="like-emoji">
    <img src="https://images.emojiterra.com/google/noto-emoji/animated-emoji/1f44d.gif" alt="Like Emoji" width="100" height="100">
</div>

<!-- Adicionando o GIF de dislike -->
<div id="dislike-emoji">
    <img src="https://images.emojiterra.com/google/noto-emoji/animated-emoji/1f44e.gif" alt="Dislike Emoji" width="100" height="100">
</div>



<div class="result-list" id="feeds"></div>

<p>
    <button id="myBtn" onclick="topFunction()" title="Go to top">
        <i class="fas fa-arrow-up"></i>
    </button>
</p>

<footer>Beta 6.0</footer>

<script async defer crossorigin="anonymous" src="https://connect.facebook.net/en_US/sdk.js#xfbml=1&version=v10.0" nonce="nonceValue"></script>
<script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>
<script async src="https://telegram.org/js/telegram-widget.js?22"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


<!-- Scripts Próprios -->
<script src="https://digupdog.com/init-fix.js"></script>
<script src="https://digupdog.com/utils.js"></script>
<script src="https://digupdog.com/feeds.js"></script>
<script src="https://digupdog.com/masonry-fix.js"></script>
<script src="https://digupdog.com/search.js"></script>
<script src="https://digupdog.com/ui.js"></script>
<script src="https://digupdog.com/main.js"></script>
<script src="https://digupdog.com/loadFeeds.js"></script>
<script src="emojiList.js"></script>

<!-- Script Masonry - Adicionar após carregar feeds.js -->
<script>
// Aguarda DOM carregar completamente
document.addEventListener('DOMContentLoaded', function() {
    // Força relayout após 2 segundos para garantir posicionamento correto
    setTimeout(function() {
        if (window.masonry) {
            window.masonry.relayout();
        }
    }, 2000);
    
    // Relayout adicional após 5 segundos para garantir que todos os embeds foram carregados
    setTimeout(function() {
        if (window.masonry) {
            window.masonry.relayout();
        }
    }, 5000);
});

// Detecta mudanças de orientação em dispositivos móveis
window.addEventListener('orientationchange', function() {
    setTimeout(function() {
        if (window.masonry) {
            window.masonry.updateColumns();
            window.masonry.relayout();
        }
    }, 500);
});
</script>


<!-- Função para limpar o campo de busca -->
<script>
function clearInput() {
    document.getElementById('search-query').value = ''; // Limpa o conteúdo do campo
}


$(document).on('click', '.save-btn', function() {
    var feedId = $(this).data('feed-id');
    var buttonElement = $(this);

    // Verifica se o feed já está salvo ou não
    var isSaved = buttonElement.hasClass('saved');

    // Definir a ação (salvar ou desfavoritar)
    var action = isSaved ? 'unsave' : 'save';

    $.post('save_favorite.php', { feed_id: feedId, action: action }, function(response) {
        if (response.status === 'success') {
            if (action === 'save') {
                // Se o item foi salvo, muda para verde e mantém o ícone
                buttonElement.addClass('saved').html('<i class="fas fa-bookmark"></i>');
                buttonElement.css('color', '#28a745'); // Verde quando salvo
            } else {
                // Se o item foi desfavoritado, muda para cinza e mantém o ícone
                buttonElement.removeClass('saved').html('<i class="fas fa-bookmark"></i>');
                buttonElement.css('color', '#cccccc'); // Cinza claro quando não salvo
            }
        } else if (response.redirect) {
            // Se a resposta contém um redirecionamento, vai para a página de login
            window.location.href = response.redirect;
        } else {
            alert('Error: ' + response.message);
        }
    }, 'json').fail(function(xhr, status, error) {
        alert('Error communicating with the server: ' + error);
    });
});



$(document).on('click', '.post-comment-btn', function() {
    var feedId = $(this).data('feed-id');
    var commentText = $('#new-comment-' + feedId).val();

    if (commentText.trim() === "") {
        alert("Comment cannot be empty.");
        return;
    }

    $.ajax({
        url: 'post_comment.php',
        type: 'POST',
        data: { feed_id: feedId, comment_text: commentText },
        dataType: 'json', // Interpreta a resposta como JSON
        success: function(response) {
            console.log(response); // Para depuração

            if (response.success) {
                // Adiciona o novo comentário à lista de comentários
                $('#comments-' + feedId).append('<p>' + commentText + '</p>');
                $('#new-comment-' + feedId).val('');  // Limpa o campo de comentário
                
                // Atualiza a contagem de comentários
                var commentsCountElement = $('#comments-count-' + feedId);
                var currentCount = parseInt(commentsCountElement.text()) || 0;
                commentsCountElement.text(currentCount + 1);  // Incrementa a contagem

                // Muda a cor do ícone de comentários para azul
                var commentIcon = $('#comment-icon-' + feedId);
                commentIcon.css('color', 'blue'); // Muda a cor para azul
                commentIcon.addClass('commented'); // Adiciona uma classe para indicar que foi comentado

            } else if (response.message === 'User not logged in. Please login to comment.') {
                // Exibe mensagem de login e redireciona
                alert(response.message);
                window.location.href = 'https://digupdog.com/login.html'; // Redireciona para a página de login
            } else {
                // Mostra a mensagem de erro no console
                alert(response.message || 'Error posting comment.');
            }
        },
        error: function(xhr, status, error) {
            console.log(xhr.responseText); // Para depurar o erro
            alert('Failed to post comment.');
        }
    });
});



$(document).on('input', 'textarea', function () {
    this.style.height = 'auto'; // Redefine a altura para ajustar dinamicamente
    this.style.height = (this.scrollHeight) + 'px'; // Ajusta a altura de acordo com o conteúdo
});


// Função para exibir o GIF de like com animação
function showLikeGif() {
    var likeEmoji = $('#like-emoji');
    
    // Adiciona a classe para mostrar e iniciar a animação
    likeEmoji.addClass('show');
    
    // Remove a animação após 2500ms
    setTimeout(function() {
        likeEmoji.removeClass('show');
    }, 2500);
}

// Função para exibir o GIF de dislike com animação
function showDislikeGif() {
    var dislikeEmoji = $('#dislike-emoji');
    
    // Adiciona a classe para mostrar e iniciar a animação
    dislikeEmoji.addClass('show');
    
    // Remove a animação após 2500ms
    setTimeout(function() {
        dislikeEmoji.removeClass('show');
    }, 2500);
}

// Função para curtir com efeito e atualizar a contagem de likes
$(document).on('click', '.like-btn', function() {
    var feedId = $(this).data('feed-id'); // Obtém o ID do feed
    var likeCountElement = $(this).find('.like-count'); // Localiza o elemento da contagem de likes
    var dislikeButton = $(this).siblings('.dislike-btn'); // Localiza o botão de dislike ao lado
    var likeButton = $(this); // Botão de like

    // Envia a requisição para o servidor
    $.post('update_likes.php', { feed_id: feedId, action: 'like' }, function(response) {
        if (response.status === 'success') {
            // Atualiza a contagem de likes no front-end
            likeCountElement.text(parseInt(likeCountElement.text()) + 1);
            
            // Adiciona a classe "liked" para mudar a cor
            likeButton.addClass('liked');
            dislikeButton.removeClass('disliked'); // Remove o dislike, se existir
            
            // Atualizar visual de contagem de dislikes, se o usuário mudou de "dislike" para "like"
            var dislikeCountElement = dislikeButton.find('.dislike-count');
            if (dislikeButton.hasClass('disliked')) {
                dislikeCountElement.text(parseInt(dislikeCountElement.text()) - 1);
            }

            // Exibe o GIF de like com animação
            showLikeGif();

        } else if (response.redirect) {
            // Redireciona para o login se o usuário não estiver logado
            window.location.href = response.redirect;
        } else {
            alert('Erro ao registrar o like: ' + response.message);
        }
    }, 'json').fail(function(xhr, status, error) {
        alert('Erro ao comunicar com o servidor: ' + error);
    });
});

// Função para descurtir com efeito e atualizar a contagem de dislikes
$(document).on('click', '.dislike-btn', function() {
    var feedId = $(this).data('feed-id'); // Obtém o ID do feed
    var dislikeCountElement = $(this).find('.dislike-count'); // Localiza o elemento da contagem de dislikes
    var likeButton = $(this).siblings('.like-btn'); // Localiza o botão de like ao lado
    var dislikeButton = $(this); // Botão de dislike

    // Envia a requisição para o servidor
    $.post('update_likes.php', { feed_id: feedId, action: 'dislike' }, function(response) {
        if (response.status === 'success') {
            // Atualiza a contagem de dislikes no front-end
            dislikeCountElement.text(parseInt(dislikeCountElement.text()) + 1);

            // Adiciona a classe "disliked" para mudar a cor
            dislikeButton.addClass('disliked');
            likeButton.removeClass('liked'); // Remove o like, se existir
            
            // Atualizar visual de contagem de likes, se o usuário mudou de "like" para "dislike"
            var likeCountElement = likeButton.find('.like-count');
            if (likeButton.hasClass('liked')) {
                likeCountElement.text(parseInt(likeCountElement.text()) - 1);
            }

            // Exibe o GIF de dislike com animação
            showDislikeGif();

        } else if (response.redirect) {
            // Redireciona para o login se o usuário não estiver logado
            window.location.href = response.redirect;
        } else {
            alert('Erro ao registrar o dislike: ' + response.message);
        }
    }, 'json').fail(function(xhr, status, error) {
        alert('Erro ao comunicar com o servidor: ' + error);
    });
});




// Função para converter string em cor
function stringToColor(str) {
    let hash = 0;
    for (let i = 0; i < str.length; i++) {
        hash = str.charCodeAt(i) + ((hash << 5) - hash);
    }
    let color = '#';
    for (let i = 0; i < 3; i++) {
        let value = (hash >> (i * 8)) & 0xFF;
        color += ('00' + value.toString(16)).substr(-2);
    }
    return color;
}

// Função para verificar se a cor é clara ou escura
function isColorDark(color) {
    const hex = color.replace('#', '');
    const r = parseInt(hex.substring(0, 2), 16);
    const g = parseInt(hex.substring(2, 4), 16);
    const b = parseInt(hex.substring(4, 6), 16);

    // Fórmula de luminância para determinar se a cor é clara ou escura
    const luminance = 0.299 * r + 0.587 * g + 0.114 * b;
    return luminance < 150;
}

// Função para exibir o popup com a mensagem, ícone e fundo de cor gerado pela string
function showFollowPopup(message, iconClass, followValue, action, type) {
    var popup = $('#follow-popup');

    // Gera a cor com base no valor seguido
    var bgColor = stringToColor(followValue);

    // Verifica se o fundo é escuro e ajusta a cor do texto
    var textColor = isColorDark(bgColor) ? '#fff' : '#333';

    // Define a cor de fundo e cor do texto do popup
    popup.css({
        'background-color': bgColor,
        'color': textColor
    });

    // Define o conteúdo do popup com base no tipo (author, tag, channel)
    var formattedValue;
    if (type === 'author') {
        formattedValue = '@' + followValue;
    } else if (type === 'tag') {
        formattedValue = '#' + followValue;
    } else if (type === 'channel') {
        formattedValue = 'Channel: ' + followValue;
    } else {
        formattedValue = followValue; // Caso não seja um dos três
    }

    // Insere o conteúdo no popup
    popup.html('<i class="fas ' + iconClass + ' icon"></i>' + message + ' <span class="highlight">' + formattedValue + '</span>!');
    
    // Exibe o popup com a animação
    popup.removeClass('hide').addClass('show');

    // Oculta o popup após 2.5 segundos
    setTimeout(function() {
        popup.removeClass('show').addClass('hide'); // Animação de saída
    }, 2500);
}



// Função para seguir ou deixar de seguir
$(document).on('click', '.follow-btn', function() {
    var followType = $(this).data('follow-type');
    var followValue = $(this).data('follow-value');
    var action = $(this).data('action'); // 'follow' ou 'unfollow'
    var buttonElement = $(this);

    // Adiciona o spinner de carregamento ao lado do texto/ícone
    var spinner = $('<span class="loading-spinner" style="margin-left: 8px;">...</span>');
    var currentHtml = buttonElement.html();
    buttonElement.html(currentHtml + spinner[0].outerHTML); // Mantém o texto/ícone e adiciona o spinner

    // Desabilita o botão enquanto o request é processado
    buttonElement.prop('disabled', true);

    $.post('follow.php', { follow_type: followType, follow_value: followValue, action: action }, function(response) {
        // Remove o spinner após a resposta
        buttonElement.html('');

        if (response.status === 'success') {
            var followMessage = '';
            
            if (action === 'follow') {
                buttonElement.addClass('following').removeClass('not-following');
                followMessage = 'Now following';

                // Exibe o popup de confirmação (opcional)
                showFollowPopup(followMessage, 'fa-check-circle', followValue, 'follow', followType);

                // Alterar ação para 'unfollow' e atualizar texto ou ícone
                setTimeout(function() {
                    buttonElement.data('action', 'unfollow');
                    
                    if (followType === 'author') {
                        buttonElement.html('Unfollow').css({
                            'background-color': '#28a745', // Verde
                            'color': 'white', // Texto branco
                            'font-family': 'Roboto, sans-serif', // Fonte moderna
                            'font-weight': '700', // Negrito
                            'border-radius': '5px', // Bordas arredondadas
                            'padding': '5px 10px', // Espaçamento interno
                            'border': 'none', // Remover borda
                            'cursor': 'pointer' // Muda o cursor para pointer
                        });
                    } else {
                        buttonElement.html('<i class="fas fa-check"></i>');
                    }

                    buttonElement.prop('disabled', false); // Reabilita o botão
                }, 1000);

            } else {
                buttonElement.addClass('not-following').removeClass('following');
                followMessage = 'You unfollowed';

                // Exibe o popup de confirmação (opcional)
                showFollowPopup(followMessage, 'fa-times-circle', followValue, 'unfollow', followType);

                // Alterar ação para 'follow' e atualizar texto ou ícone
                setTimeout(function() {
                    buttonElement.data('action', 'follow');
                    
                    if (followType === 'author') {
                        buttonElement.html('Follow').css({
                            'background-color': '#FFC107', // Amarelo
                            'color': 'black', // Texto preto
                            'font-family': 'Roboto, sans-serif', // Fonte moderna
                            'font-weight': '700', // Negrito
                            'border-radius': '5px', // Bordas arredondadas
                            'padding': '5px 10px', // Espaçamento interno
                            'border': 'none', // Remover borda
                            'cursor': 'pointer' // Muda o cursor para pointer
                        });
                    } else {
                        buttonElement.html('<i class="fas fa-plus"></i>');
                    }

                    buttonElement.prop('disabled', false); // Reabilita o botão
                }, 600);
            }
        } else {
            alert(response.message); // Mostra mensagem de erro
            buttonElement.prop('disabled', false); // Reabilita o botão em caso de erro
        }
    }, 'json').fail(function() {
        // Remove o spinner em caso de erro e restaura o botão original
        buttonElement.html(currentHtml);
        buttonElement.prop('disabled', false); // Reabilita o botão
        alert('Ocorreu um erro ao processar sua solicitação.');
    });
});




$(document).ready(function() {
    $('.tag-link').click(function(e) {
        e.preventDefault();
        var tag = $(this).text().substr(1); // Remove o '#'
        $('#search-query').val(tag);
        // Lógica de busca pode ser implementada aqui
    });

    document.getElementById('addPinButton').addEventListener('click', function(e) {
        <?php if (!isset($_SESSION['username'])): ?>
            e.preventDefault();
            window.location.href = 'login.html';
        <?php endif; ?>
    });

    window.addEventListener('scroll', function() {
        var loginSection = document.querySelector('.login-register-section');
        var scrollPosition = window.scrollY;
        var categoryButtons = document.querySelector('.category-buttons-container');

        if (scrollPosition > 100) {
            loginSection.style.position = 'fixed';
            loginSection.style.bottom = '10px';
            loginSection.style.left = '10px';
            loginSection.style.zIndex = '50';
            categoryButtons.style.marginBottom = loginSection.offsetHeight + 'px';
        } else {
            loginSection.style.position = 'static';
            categoryButtons.style.marginBottom = '0';
        }
    });

    document.addEventListener('DOMContentLoaded', function() {
        var tagElements = document.querySelectorAll('.tag-link');

        tagElements.forEach(function(tagElement) {
            var tagText = tagElement.dataset.tag;
            var bgColor = stringToColor(tagText);
            var textColor = isColorDark(bgColor) ? 'white' : 'black';

            tagElement.style.backgroundColor = bgColor;
            tagElement.style.color = textColor;
            tagElement.style.border = '2px solid black';
            tagElement.style.padding = '5px 10px';
            tagElement.style.marginRight = '5px';
            tagElement.style.borderRadius = '5px';
            tagElement.style.textDecoration = 'none';
            tagElement.style.display = 'inline-block';
            tagElement.style.marginBottom = '5px';
            tagElement.style.fontWeight = 'bold';

            tagElement.addEventListener('click', function(e) {
                e.preventDefault();
                var tag = this.dataset.tag;
                $('#search-query').val(tag);
                clearResults();
                performSearch();
            });
        });
    });

    function clearResults() {
        $('#feeds').empty();
    }

    function reloadTags() {
        $.ajax({
            url: 'tags.json',
            method: 'GET',
            dataType: 'json',
            success: function(response) {
                updateTags(response);
            },
            error: function(xhr, status, error) {
                console.error("Erro ao carregar as tags: ", error);
            }
        });
    }

    function updateTags(tags) {
        var container = $('#tags-container');
        container.empty();

        shuffleArray(tags);
        var limitedTags = tags.slice(0, 12);

        limitedTags.forEach(function(tag) {
            var tagElement = $('<a href="#" class="tag-link tag-search-link" data-tag="' + tag + '">#' + tag + '</a>');
            var bgColor = stringToColor(tag);
            var textColor = isColorDark(bgColor) ? 'white' : 'black';

            tagElement.css({
                'backgroundColor': bgColor,
                'color': textColor,
                'border': '2px solid black',
                'padding': '3px 3px',
                'marginRight': '5px',
                'borderRadius': '5px',
                'textDecoration': 'none',
                'display': 'inline-block',
                'marginBottom': '5px',
                'fontWeight': 'bold'
            });

            container.append(tagElement);
        });

        container.append('<a href="#" id="reload-tags" title="Recarregar tags"><i class="fas fa-sync-alt"></i></a>');

        // Adiciona novamente o evento ao botão de recarregar tags
        document.getElementById('reload-tags').addEventListener('click', function(e) {
            e.preventDefault();
            reloadTags();
        });
    }

    function shuffleArray(array) {
        for (var i = array.length - 1; i > 0; i--) {
            var j = Math.floor(Math.random() * (i + 1));
            var temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }

    reloadTags();

    document.querySelector('.menu-button').addEventListener('click', function() {
        let icon = this.querySelector('.menu-icon');
        let sideMenu = document.querySelector('.side-menu');
        let overlay = document.querySelector('.overlay');

        if (sideMenu.style.width === '30%' || sideMenu.style.width === '95%') {
            sideMenu.style.width = '0';
            overlay.style.display = 'none';
            document.body.style.overflow = 'auto';
            this.classList.remove('open');
            icon.classList.remove('fa-times');
            icon.classList.add('fa-bars');
        } else {
            sideMenu.style.width = window.innerWidth <= 768 ? '95%' : '30%';
            overlay.style.display = 'block';
            document.body.style.overflow = 'hidden';
            this.classList.add('open');
            icon.classList.remove('fa-bars');
            icon.classList.add('fa-times');
        }
    });

    document.querySelector('.home-button').addEventListener('click', function() {
        window.location.reload();
    });
});




</script>


</body>
</html>