<?php
require_once __DIR__ . '/bootstrap.php';

$action = route_action();
if ($action === 'get_comments') handle_get_comments();
if ($action === 'post_comment') handle_post_comment();

json_fail('UNKNOWN_ACTION', 'No such comments action: ' . $action, 404);

function handle_get_comments() {
    $pdo = pdo();
    $feed_id = (int) param('feed_id', 0);
    if ($feed_id <= 0) json_fail('BAD_REQUEST','feed_id required', 422);

    $page = max(1, (int)param('page', 1));
    $per = min(100, max(1, (int)param('per_page', 20)));
    $offset = ($page - 1) * $per;

    // Stats via comment_stats view if it exists
    $has_stats = table_exists('comment_stats');

    $sql = "
        SELECT c.*, u.username, u.profile_picture
        " . ($has_stats ? ", s.likes_count, s.dislikes_count, s.replies_count, s.total_reactions " : "") . "
        FROM comments c
        LEFT JOIN user_myhashtag u ON u.ID = c.user_id
        " . ($has_stats ? "LEFT JOIN comment_stats s ON s.comment_id = c.comment_id " : "") . "
        WHERE c.feed_id = :fid AND c.is_deleted = 0
        ORDER BY c.created_at DESC
        LIMIT :limit OFFSET :offset
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':fid', $feed_id, PDO::PARAM_INT);
    $stmt->bindValue(':limit', $per, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    $rows = $stmt->fetchAll();
    json_ok(['comments' => $rows, 'meta'=>['page'=>$page,'per_page'=>$per]]);
}

function handle_post_comment() {
    $user = require_user();
    $pdo = pdo();
    $feed_id = (int)param('feed_id', 0);
    $text = trim((string)param('comment_text',''));
    $parent = param('parent_comment_id', null);
    if ($feed_id <= 0 || $text === '') json_fail('BAD_REQUEST','feed_id and comment_text required', 422);
    $stmt = $pdo->prepare("INSERT INTO comments (feed_id, user_id, comment_text, created_at, parent_comment_id, is_deleted, is_edited, is_pinned) VALUES (:f,:u,:t,NOW(),:p,0,0,0)");
    $stmt->execute([':f'=>$feed_id, ':u'=>$user['ID'], ':t'=>$text, ':p'=> $parent !== null ? (int)$parent : null]);
    $id = (int)$pdo->lastInsertId();
    json_ok(['comment_id'=>$id]);
}
