<?php
// Health check – No redirect to /public here.
// This page verifies DB connection and shows minimal diagnostics.
header('Content-Type: text/html; charset=utf-8');
$cfg = require __DIR__ . '/../config/config.php';
$ok = false; $msg = ''; $ver = phpversion();
try {
  $dsn = "mysql:host={$cfg['db']['host']};dbname={$cfg['db']['name']};charset={$cfg['db']['charset']};port={$cfg['db']['port']}";
  $pdo = new PDO($dsn, $cfg['db']['user'], $cfg['db']['pass'], [PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION]);
  $ok = true;
} catch (Throwable $e) { $msg = $e->getMessage(); }
?><!doctype html>
<html><head><meta charset="utf-8"><title>Install / Health</title>
<style>body{font-family:system-ui,Segoe UI,Arial;margin:30px;color:#e7ecf7;background:#0b1220} code{background:#0e1627;padding:2px 6px;border-radius:6px} .ok{color:#6cf0c2} .fail{color:#ff6c7e}</style>
</head><body>
<h2>DigUpDog Masonry – Environment</h2>
<ul>
  <li>PHP version: <strong><?php echo htmlspecialchars($ver); ?></strong></li>
  <li>DB Host: <code><?php echo htmlspecialchars($cfg['db']['host']); ?></code></li>
  <li>DB Name: <code><?php echo htmlspecialchars($cfg['db']['name']); ?></code></li>
  <li>DB User: <code><?php echo htmlspecialchars($cfg['db']['user']); ?></code></li>
  <li>Connection: <?php echo $ok ? '<span class="ok">OK</span>' : '<span class="fail">FAILED</span>'; ?></li>
</ul>
<?php if (!$ok): ?>
<p class="fail">Error: <?php echo htmlspecialchars($msg); ?></p>
<?php else: ?>
<p class="ok">All good. Go to <a href="../index.php">Home</a>.</p>
<?php endif; ?>
</body></html>
