<?php
$base = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'] ?? '')), '/.');
if ($base) $base .= '/';
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title>View item – DigUpDog Masonry</title>
  <link rel="stylesheet" href="<?php echo $base; ?>public/css/styles.css">
</head>
<body>
<header>
  <div class="container">
    <div class="brand"><span class="logo"></span> <span>DigUpDog Masonry</span></div>
    <nav>
      <a href="<?php echo $base; ?>index.php">Home</a>
      <a href="<?php echo $base; ?>trending.php">Trending</a>
      <a href="<?php echo $base; ?>sources.php">Sources</a>
      <a href="<?php echo $base; ?>profile.php">Profile</a>
      <a href="<?php echo $base; ?>login.php">Login</a>
    </nav>
  </div>
</header>

<main class="container" id="root">
  <div class="notice">Loading…</div>
</main>

<footer><div class="container small">Comments are loaded via API.</div></footer>

<script>
const ID = <?php echo $id ?: 0; ?>;
async function loadItem(){
  const root = document.getElementById('root');
  if (!ID){ root.innerHTML = '<div class="empty">Missing id</div>'; return; }
  let r = await fetch('api/router.php?action=get_feed&id='+ID);
  let j = await r.json();
  if (!j.ok){ root.innerHTML = '<div class="empty">Not found</div>'; return; }
  const it = j.item;
  const desc = (it.description||'').replace(/<[^>]+>/g,'').slice(0,1000);
  root.innerHTML = `
  <article class="card">
    ${it.thumbnail?`<figure><img src="${it.thumbnail}" alt=""></figure>`:''}
    <div class="content">
      <h2 class="title">${it.title}</h2>
      <div class="meta">
        <span class="kv"><span class="dot"></span> ${it.source_domain||''}</span>
        <span class="kv">By ${it.author||'Unknown'}</span>
        <span class="kv">${it.pubDate||''}</span>
        <span class="kv">👍 ${it.likes||0}</span>
        <span class="kv">👎 ${it.dislikes||0}</span>
      </div>
      ${desc?`<p class="desc">${desc}</p>`:''}
      <div class="actions">
        <a class="ghost" href="${it.link}" target="_blank" rel="noopener" style="flex:1;text-align:center">Open original</a>
      </div>
    </div>
  </article>

  <section id="comments">
    <h3>Comments</h3>
    <div id="commentForm" class="controls">
      <input id="commentText" type="text" placeholder="Write a comment">
      <button id="sendComment" class="primary">Send</button>
    </div>
    <div id="commentsList" class="list"></div>
  </section>
  `;
  document.getElementById('sendComment').addEventListener('click', async ()=>{
    const text = document.getElementById('commentText').value.trim();
    if (!text) return;
    const r = await fetch('api/router.php?action=post_comment', {method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body:new URLSearchParams({feed_id:String(ID), comment_text:text})});
    const j = await r.json();
    if (!j.ok) { alert(j.message||j.error); return; }
    document.getElementById('commentText').value='';
    await loadComments();
  });
  await loadComments();
}

async function loadComments(){
  const list = document.getElementById('commentsList');
  const r = await fetch('api/router.php?action=get_comments&feed_id='+ID+'&per_page=50');
  const j = await r.json();
  if (!j.ok) { list.innerHTML = '<div class="empty">Failed to load comments</div>'; return; }
  if (!j.comments.length) { list.innerHTML = '<div class="empty">No comments yet</div>'; return; }
  list.innerHTML = j.comments.map(c => `
    <article class="card">
      <div class="content">
        <div class="meta">
          <span class="kv">${c.username||'User #'+c.user_id}</span>
          <span class="kv">${c.created_at||''}</span>
          ${typeof c.likes_count!=='undefined'?`<span class="kv">👍 ${c.likes_count}</span>`:''}
          ${typeof c.dislikes_count!=='undefined'?`<span class="kv">👎 ${c.dislikes_count}</span>`:''}
        </div>
        <div>${(c.comment_text||'').replace(/</g,'&lt;')}</div>
      </div>
    </article>
  `).join('');
}

document.addEventListener('DOMContentLoaded', loadItem);
</script>
</body>
</html>
