<?php
require_once __DIR__ . '/../config.php';

/**
 * File: api_reactions.php
 * Toggle de reactions (emoji) em comentários
 * POST { comment_id, reaction } -> alterna; retorna mapa atualizado:
 *      { success, reactions: { "👍": {count, mine}, "❤️": {...}, ... } }
 * GET  ?comment_id=ID          -> retorna o mesmo mapa
 */
session_start();
header('Content-Type: application/json; charset=utf-8');

$host = 'localhost';
$db   = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success'=>false,'error'=>'db_connection_failed']);
    exit;
}

function me(PDO $pdo){ 
    if (!isset($_SESSION['username'])) return null;
    $st = $pdo->prepare("SELECT ID, username FROM user_myhashtag WHERE username = ? LIMIT 1");
    $st->execute([$_SESSION['username']]);
    return $st->fetch(PDO::FETCH_ASSOC) ?: null;
}
function getMap(PDO $pdo, int $cid, ?int $meId){
    $rs = $pdo->prepare("SELECT reaction, COUNT(*) AS cnt FROM comment_reactions WHERE comment_id = ? GROUP BY reaction");
    $rs->execute([$cid]);
    $map = [];
    while($r=$rs->fetch(PDO::FETCH_ASSOC)){
        $map[$r['reaction']] = ['count'=>(int)$r['cnt'], 'mine'=>false];
    }
    if ($meId){
        $ms = $pdo->prepare("SELECT reaction FROM comment_reactions WHERE comment_id = ? AND user_id = ?");
        $ms->execute([$cid, $meId]);
        while($m=$ms->fetch(PDO::FETCH_ASSOC)){
            $rx = $m['reaction'];
            if (!isset($map[$rx])) $map[$rx] = ['count'=>0,'mine'=>true];
            else $map[$rx]['mine'] = true;
        }
    }
    return $map;
}

if ($_SERVER['REQUEST_METHOD']==='GET'){
    $cid = isset($_GET['comment_id']) ? (int)$_GET['comment_id'] : 0;
    if ($cid<=0){ echo json_encode(['success'=>false]); exit; }
    $user = me($pdo);
    $map = getMap($pdo, $cid, $user ? (int)$user['ID'] : null);
    echo json_encode(['success'=>true, 'reactions'=>$map]); exit;
}

if ($_SERVER['REQUEST_METHOD']==='POST'){
    $user = me($pdo);
    if (!$user){ echo json_encode(['success'=>false, 'error'=>'not_logged_in']); exit; }
    $payload = json_decode(file_get_contents('php://input'), true);
    $cid = isset($payload['comment_id']) ? (int)$payload['comment_id'] : 0;
    $rx  = isset($payload['reaction']) ? trim((string)$payload['reaction']) : '';
    if ($cid<=0 || $rx===''){ echo json_encode(['success'=>false,'error'=>'invalid']); exit; }

    // toggle
    $ck = $pdo->prepare("SELECT id FROM comment_reactions WHERE comment_id=? AND user_id=? AND reaction=? LIMIT 1");
    $ck->execute([$cid, $user['ID'], $rx]);
    $id = (int)$ck->fetchColumn();
    if ($id){
        $pdo->prepare("DELETE FROM comment_reactions WHERE id = ?")->execute([$id]);
    } else {
        $pdo->prepare("INSERT INTO comment_reactions (comment_id, user_id, reaction, created_at) VALUES (?, ?, ?, NOW())")->execute([$cid, $user['ID'], $rx]);
    }
    $map = getMap($pdo, $cid, (int)$user['ID']);
    echo json_encode(['success'=>true, 'reactions'=>$map]); exit;
}

http_response_code(405);
echo json_encode(['success'=>false]);
