<?php
/**
 * =========================================================
 * File: index.php
 * Project: DigUpDOG v10.0 ULTIMATE
 * Description: Main entry point with modern ULTIMATE UI
 * =========================================================
 */

// Define app constant
define('DIGUPDOG_APP', true);

// Include configuration
require_once __DIR__ . '/config.php';

// Page metadata
$page_title = '🐕 DigUpDOG Universe — The ULTIMATE Social SuperPlatform • v10.0 ULTIMATE';
$page_description = '450+ features combining Telegram, Discord, X, Facebook, Instagram, TikTok, YouTube, Netflix, Twitch, Reddit, WhatsApp, Steam, and 20+ more platforms into ONE!';
$page_url = SITE_URL;

// Get current user
$current_user = null;
if (isset($_SESSION['user_id'])) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM user_myhashtag WHERE id = ? AND is_active = 1");
        $stmt->execute([$_SESSION['user_id']]);
        $current_user = $stmt->fetch();
    } catch (Exception $e) {
        // User not found
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
  <title><?php echo htmlspecialchars($page_title); ?></title>
  <meta name="description" content="<?php echo htmlspecialchars($page_description); ?>">
  <meta name="color-scheme" content="dark light">

  <!-- Open Graph -->
  <meta property="og:title" content="<?php echo htmlspecialchars($page_title); ?>">
  <meta property="og:description" content="<?php echo htmlspecialchars($page_description); ?>">
  <meta property="og:url" content="<?php echo htmlspecialchars($page_url); ?>">
  <meta property="og:type" content="website">

  <!-- Favicon -->
  <link rel="icon" href="<?php echo ASSETS_URL; ?>/images/favicon.png">

  <!-- CSS -->
  <link rel="stylesheet" href="<?php echo ASSETS_URL; ?>/css/main.css?v=<?php echo SITE_VERSION; ?>">

  <style>
    <?php include __DIR__ . '/assets/css/inline-critical.css'; ?>
  </style>
</head>
<body data-theme="dark" data-density="comfy">

  <!-- Top Navigation Bar -->
  <header class="topbar">
    <button class="btn icon" id="menuToggle" title="Menu">☰</button>

    <div class="logo" onclick="location.href='<?php echo SITE_URL; ?>'">
      <div class="logo-icon"></div>
      <span class="logo-text">DIGUPDOG</span>
      <span class="badge pro"><?php echo SITE_VERSION; ?></span>
    </div>

    <div class="search-box">
      <span class="search-icon">🔍</span>
      <input type="text" id="searchInput" placeholder="Search everything across all platforms...">
      <span class="search-clear" onclick="this.previousElementSibling.value='';this.style.display='none'">×</span>
    </div>

    <button class="btn ghost icon" id="callBtn" title="Start Video Call">📞</button>
    <button class="btn ghost icon" id="themeToggle" title="Toggle theme">🌙</button>

    <?php if ($current_user): ?>
    <button class="btn icon" id="statusBtn" title="Status" style="position:relative">
      <span class="status-indicator status-online"></span>
      🟢
    </button>

    <button class="btn icon" id="notifToggle" title="Notifications" style="position:relative">
      🔔
      <span class="badge count" id="notifCount">0</span>
    </button>

    <button class="btn primary" id="createBtn">+ Create</button>

    <div class="user-menu">
      <button class="btn icon" onclick="UI.toggleDropdown('user-dropdown')">
        <img src="<?php echo htmlspecialchars($current_user['avatar'] ?? DEFAULT_AVATAR); ?>"
             alt="<?php echo htmlspecialchars($current_user['username']); ?>"
             class="avatar-sm">
      </button>
      <div class="dropdown-menu" id="user-dropdown">
        <a href="@<?php echo htmlspecialchars($current_user['username']); ?>" class="dropdown-item">
          👤 Profile
        </a>
        <a href="settings" class="dropdown-item">⚙️ Settings</a>
        <a href="premium" class="dropdown-item">👑 Premium</a>
        <hr class="dropdown-divider">
        <a href="logout" class="dropdown-item text-danger">🚪 Logout</a>
      </div>
    </div>
    <?php else: ?>
    <button class="btn" onclick="location.href='login'">Login</button>
    <button class="btn primary" onclick="location.href='register'">Sign Up</button>
    <?php endif; ?>
  </header>

  <div class="app" id="app">

    <!-- Left Sidebar Navigation -->
    <aside class="sidebar left" id="leftSidebar">
      <nav>
        <div class="section-title">🔥 EXPLORE</div>
        <a class="nav-item active" href="<?php echo SITE_URL; ?>">
          <span class="nav-icon">🏠</span>
          <span class="nav-text">Home Feed</span>
        </a>
        <a class="nav-item" href="trending">
          <span class="nav-icon">🔥</span>
          <span class="nav-text">Trending</span>
          <span class="nav-badge">47</span>
        </a>
        <a class="nav-item" href="foryou">
          <span class="nav-icon">✨</span>
          <span class="nav-text">For You</span>
        </a>
        <a class="nav-item" href="stories">
          <span class="nav-icon">⭐</span>
          <span class="nav-text">Stories</span>
          <span class="nav-badge">15</span>
        </a>

        <div class="section-title">📹 WATCH</div>
        <a class="nav-item" href="videos">
          <span class="nav-icon">📹</span>
          <span class="nav-text">Videos</span>
        </a>
        <a class="nav-item" href="shorts">
          <span class="nav-icon">🎬</span>
          <span class="nav-text">Shorts</span>
        </a>
        <a class="nav-item" href="reels">
          <span class="nav-icon">📱</span>
          <span class="nav-text">Reels</span>
        </a>
        <a class="nav-item" href="streams">
          <span class="nav-icon">📺</span>
          <span class="nav-text">Live Streams</span>
          <span class="badge live" style="margin-left:auto;font-size:8px;padding:2px 6px">LIVE</span>
        </a>

        <div class="section-title">💬 SOCIAL</div>
        <a class="nav-item" href="messages">
          <span class="nav-icon">💬</span>
          <span class="nav-text">Messages</span>
          <span class="nav-badge">8</span>
        </a>
        <a class="nav-item" href="channels">
          <span class="nav-icon">📢</span>
          <span class="nav-text">Channels</span>
        </a>
        <a class="nav-item" href="servers">
          <span class="nav-icon">🖥️</span>
          <span class="nav-text">Servers</span>
        </a>
        <a class="nav-item" href="groups">
          <span class="nav-icon">👥</span>
          <span class="nav-text">Groups</span>
        </a>

        <div class="section-title">🎮 ENTERTAINMENT</div>
        <a class="nav-item" href="gaming">
          <span class="nav-icon">🎮</span>
          <span class="nav-text">Gaming</span>
        </a>
        <a class="nav-item" href="music">
          <span class="nav-icon">🎵</span>
          <span class="nav-text">Music</span>
        </a>
        <a class="nav-item" href="watch">
          <span class="nav-icon">🍿</span>
          <span class="nav-text">Watch</span>
        </a>
        <a class="nav-item" href="marketplace">
          <span class="nav-icon">🛍️</span>
          <span class="nav-text">Marketplace</span>
        </a>

        <div class="section-title">📊 CONTENT</div>
        <a class="nav-item" href="threads">
          <span class="nav-icon">🧵</span>
          <span class="nav-text">Threads</span>
        </a>
        <a class="nav-item" href="communities">
          <span class="nav-icon">🌐</span>
          <span class="nav-text">Communities</span>
        </a>
        <a class="nav-item" href="discover">
          <span class="nav-icon">🔍</span>
          <span class="nav-text">Discover</span>
        </a>

        <?php if ($current_user): ?>
        <div class="section-title">👤 PERSONAL</div>
        <a class="nav-item" href="notifications">
          <span class="nav-icon">🔔</span>
          <span class="nav-text">Notifications</span>
          <span class="nav-badge" id="nav-notif-count">0</span>
        </a>
        <a class="nav-item" href="bookmarks">
          <span class="nav-icon">🔖</span>
          <span class="nav-text">Bookmarks</span>
        </a>
        <a class="nav-item" href="analytics">
          <span class="nav-icon">📊</span>
          <span class="nav-text">Analytics</span>
        </a>
        <a class="nav-item" href="wallet">
          <span class="nav-icon">💰</span>
          <span class="nav-text">Wallet</span>
        </a>
        <a class="nav-item" href="settings">
          <span class="nav-icon">⚙️</span>
          <span class="nav-text">Settings</span>
        </a>
        <a class="nav-item" href="@<?php echo htmlspecialchars($current_user['username']); ?>">
          <span class="nav-icon">👤</span>
          <span class="nav-text">Profile</span>
        </a>

        <div class="section-title">🌟 PREMIUM</div>
        <a class="nav-item" href="premium">
          <span class="nav-icon">👑</span>
          <span class="nav-text">Premium Features</span>
          <span class="badge premium" style="margin-left:auto;font-size:8px;padding:3px 7px">PRO</span>
        </a>
        <?php endif; ?>
      </nav>
    </aside>

    <!-- Main Content Area -->
    <main class="main" id="mainContent">

      <!-- Stories Bar -->
      <?php if ($current_user): ?>
      <div class="card pane mb">
        <div class="stories" id="stories">
          <div class="story add" onclick="UI.createStory()">
            <div class="story-ring">
              <div class="story-avatar" style="background:linear-gradient(135deg,#7c3aed,#a855f7)">+</div>
            </div>
            <div class="story-name">Your Story</div>
          </div>
          <!-- Stories loaded via JavaScript -->
        </div>
      </div>
      <?php endif; ?>

      <!-- Post Composer -->
      <?php if ($current_user): ?>
      <div class="composer">
        <div class="composer-input">
          <div class="avatar" style="background: linear-gradient(135deg, #7c3aed, #a855f7)">
            <?php echo strtoupper(substr($current_user['username'], 0, 2)); ?>
            <span class="status-indicator status-online"></span>
          </div>
          <textarea id="postInput" placeholder="What's happening? Share with the world..."></textarea>
        </div>
        <div class="composer-actions">
          <button class="btn ghost icon" title="Photo">📷</button>
          <button class="btn ghost icon" title="Video">🎥</button>
          <button class="btn ghost icon" title="Poll">📊</button>
          <button class="btn ghost icon" title="GIF">🎬</button>
          <button class="btn ghost icon" title="Sticker">😎</button>
          <button class="btn ghost icon" title="Location">📍</button>
          <button class="btn ghost icon" title="Tag People">🏷️</button>
          <button class="btn ghost icon" title="Schedule">⏰</button>
          <div class="grow"></div>
          <span class="tiny" id="charCount">0/5000</span>
          <button class="btn primary" id="postBtn">Post</button>
        </div>
      </div>
      <?php endif; ?>

      <!-- Category Filters -->
      <div class="categories" id="categories">
        <div class="chip active" data-cat="all">🌐 All</div>
        <div class="chip" data-cat="trending">🔥 Trending</div>
        <div class="chip" data-cat="following">👥 Following</div>
        <div class="chip" data-cat="news">📰 News</div>
        <div class="chip" data-cat="tech">💻 Tech</div>
        <div class="chip" data-cat="gaming">🎮 Gaming</div>
        <div class="chip" data-cat="music">🎵 Music</div>
        <div class="chip" data-cat="sports">⚽ Sports</div>
        <div class="chip" data-cat="art">🎨 Art</div>
        <div class="chip" data-cat="food">🍕 Food</div>
        <div class="chip" data-cat="travel">✈️ Travel</div>
        <div class="chip" data-cat="fashion">👗 Fashion</div>
      </div>

      <!-- Feed Container (Masonry Grid) -->
      <div class="masonry" id="masonry">
        <div class="loading-container">
          <div class="spinner"></div>
          <p>Loading amazing content...</p>
        </div>
      </div>

      <div class="text-center mt">
        <button class="btn" id="loadMore">
          <span class="loading hidden" id="loadingSpinner"></span>
          <span id="loadMoreText">Load More Posts</span>
        </button>
      </div>
    </main>

    <!-- Right Sidebar (Trending/Suggestions) -->
    <aside class="sidebar right" id="rightSidebar">
      <div class="stack">

        <!-- Trending Tags -->
        <div class="card pane">
          <h3 style="margin-bottom:14px">🔥 Trending Topics</h3>
          <div id="trendsList">
            <?php
            try {
                $stmt = $pdo->query("
                    SELECT h.hashtag, COUNT(*) as count
                    FROM feed_hashtags fh
                    JOIN hashtags h ON fh.hashtag_id = h.id
                    WHERE fh.created_at >= DATE_SUB(NOW(), INTERVAL 24 HOUR)
                    GROUP BY h.hashtag
                    ORDER BY count DESC
                    LIMIT 10
                ");
                $trending = $stmt->fetchAll();

                if ($trending) {
                    foreach ($trending as $idx => $tag) {
                        $tag_name = htmlspecialchars($tag['hashtag']);
                        echo "<div style='padding:10px;border-radius:9px;cursor:pointer;transition:background .2s' onmouseover=\"this.style.background='var(--elev)'\" onmouseout=\"this.style.background='transparent'\" onclick=\"location.href='tag/{$tag_name}'\">
                                <div style='font-weight:700;color:var(--accent);margin-bottom:4px'>" . ($idx + 1) . ". #{$tag_name}</div>
                                <div class='tiny'>{$tag['count']}K posts • Trending</div>
                              </div>";
                    }
                } else {
                    echo '<p class="tiny">No trending topics yet</p>';
                }
            } catch (Exception $e) {
                echo '<p class="tiny">Unable to load trends</p>';
            }
            ?>
          </div>
        </div>

        <!-- Suggested Users -->
        <?php if ($current_user): ?>
        <div class="card pane">
          <h3 style="margin-bottom:14px">✨ Suggested For You</h3>
          <div id="suggestionsList">
            <?php
            try {
                $stmt = $pdo->prepare("
                    SELECT u.id, u.username, u.avatar, u.bio,
                           COUNT(DISTINCT f.id) as follower_count
                    FROM user_myhashtag u
                    LEFT JOIN follows f ON u.id = f.following_id
                    WHERE u.id != ?
                    AND u.id NOT IN (
                        SELECT following_id FROM follows WHERE follower_id = ?
                    )
                    AND u.is_active = 1
                    GROUP BY u.id
                    ORDER BY follower_count DESC
                    LIMIT 5
                ");
                $stmt->execute([$current_user['id'], $current_user['id']]);
                $suggested = $stmt->fetchAll();

                if ($suggested) {
                    foreach ($suggested as $user) {
                        $username = htmlspecialchars($user['username']);
                        $avatar = htmlspecialchars($user['avatar'] ?? DEFAULT_AVATAR);
                        $bio = htmlspecialchars(substr($user['bio'] ?? '', 0, 40));

                        echo "<div class='row' style='margin-bottom:12px'>
                                <div class='avatar' style='width:38px;height:38px;font-size:14px;background:hsl(" . (crc32($username) % 360) . ",65%,55%)'>" . strtoupper(substr($username, 0, 1)) . "</div>
                                <div style='flex:1;min-width:0'>
                                  <strong style='display:block;font-size:13px'>{$username}</strong>
                                  <div class='tiny'>{$user['follower_count']} followers</div>
                                </div>
                                <button class='btn small primary' onclick='Feed.handleFollow({$user['id']})'>Follow</button>
                              </div>";
                    }
                } else {
                    echo '<p class="tiny">No suggestions available</p>';
                }
            } catch (Exception $e) {
                echo '<p class="tiny">Unable to load suggestions</p>';
            }
            ?>
          </div>
        </div>
        <?php endif; ?>

        <!-- Quick Stats -->
        <div class="card pane">
          <h3 style="margin-bottom:14px">📊 Network Stats</h3>
          <div class="tiny">
            <?php
            try {
                $posts = $pdo->query("SELECT COUNT(*) FROM pinfeeds WHERE is_active = 1")->fetchColumn();
                $users = $pdo->query("SELECT COUNT(*) FROM user_myhashtag WHERE is_active = 1")->fetchColumn();
                $comments = $pdo->query("SELECT COUNT(*) FROM comments WHERE is_active = 1")->fetchColumn();

                echo "<div class='row' style='justify-content:space-between;margin-bottom:6px'>
                        <span>Posts:</span>
                        <strong>" . number_format($posts) . "</strong>
                      </div>
                      <div class='row' style='justify-content:space-between;margin-bottom:6px'>
                        <span>Users:</span>
                        <strong>" . number_format($users) . "</strong>
                      </div>
                      <div class='row' style='justify-content:space-between'>
                        <span>Comments:</span>
                        <strong>" . number_format($comments) . "</strong>
                      </div>";
            } catch (Exception $e) {
                echo '<p>Stats unavailable</p>';
            }
            ?>
          </div>
        </div>

      </div>
    </aside>

  </div>

  <!-- Mobile Navigation -->
  <nav class="mobile-nav">
    <div class="mobile-nav-items">
      <button class="mobile-nav-item active" onclick="location.href='<?php echo SITE_URL; ?>'">🏠</button>
      <button class="mobile-nav-item" onclick="location.href='videos'">📹</button>
      <button class="mobile-nav-item" onclick="location.href='messages'">💬</button>
      <button class="mobile-nav-item" onclick="location.href='notifications'">🔔</button>
      <button class="mobile-nav-item" onclick="location.href='@<?php echo htmlspecialchars($current_user['username'] ?? ''); ?>'">👤</button>
    </div>
  </nav>

  <!-- FAB Button -->
  <div class="fab">
    <button id="fabBtn">+</button>
  </div>

  <!-- Toast Container -->
  <div class="toast-container" id="toastContainer"></div>

  <!-- Load Scripts -->
  <script src="<?php echo ASSETS_URL; ?>/js/app.js?v=<?php echo SITE_VERSION; ?>"></script>
  <script src="<?php echo ASSETS_URL; ?>/js/feed.js?v=<?php echo SITE_VERSION; ?>"></script>
  <script src="<?php echo ASSETS_URL; ?>/js/api.js?v=<?php echo SITE_VERSION; ?>"></script>

  <script>
  // Initialize application
  document.addEventListener('DOMContentLoaded', () => {
      // Load initial feed
      Feed.loadInitialFeed();

      // Load stories
      if (document.getElementById('stories')) {
          Feed.loadStories();
      }

      // Initialize notifications
      <?php if ($current_user): ?>
      Notifications.init();
      <?php endif; ?>

      console.log('🐕 DigUpDOG ULTIMATE v10.0 initialized!');
  });
  </script>
</body>
</html>
