<?php
$base = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'] ?? '')), '/.');
if ($base) $base .= '/';
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Trending – DigUpDog Masonry</title>
  <link rel="stylesheet" href="<?php echo $base; ?>public/css/styles.css">
</head>
<body data-page="home">
<header>
  <div class="container">
    <div class="brand"><span class="logo"></span> <span>DigUpDog Masonry</span></div>
    <nav>
      <a href="<?php echo $base; ?>index.php">Home</a>
      <a class="active" href="<?php echo $base; ?>trending.php">Trending</a>
      <a href="<?php echo $base; ?>sources.php">Sources</a>
      <a href="<?php echo $base; ?>profile.php">Profile</a>
      <a href="<?php echo $base; ?>login.php">Login</a>
    </nav>
  </div>
</header>

<main class="container">
  <div class="controls">
    <input id="q" type="text" placeholder="Search">
    <input id="domain" type="text" placeholder="Domain">
    <input id="author" type="text" placeholder="Author">
    <input id="tags" type="text" placeholder="Tags">
    <select id="order"><option value="trending" selected>Trending</option></select>
    <select id="per_page"><option>24</option><option selected>36</option><option>48</option></select>
    <button class="primary" id="searchBtn">Update</button>
  </div>

  <section class="grid" id="grid"></section>
  <div style="text-align:center;margin:10px 0 30px">
    <button id="loadMore" class="ghost" data-page="2" data-hasnext="0" style="display:none">Load more</button>
  </div>
</main>

<footer>
  <div class="container small">Trending mixes recency, views and reactions over 14 days.</div>
</footer>

<script>
document.addEventListener('DOMContentLoaded', () => {
  const order = document.getElementById('order'); order.value = 'trending';
  if (document.body.dataset.page === 'home') initHome();
});
</script>
<script src="<?php echo $base; ?>public/js/app.js"></script>
</body>
</html>
