<?php
session_start(); // Inicia a sessão para verificar se o usuário está logado

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'User not logged in', 'redirect' => 'https://digupdog.com/login.html']);
    exit();
}

$user_id = $_SESSION['user_id'];
$feedId = isset($_POST['feed_id']) ? intval($_POST['feed_id']) : null;
$action = isset($_POST['action']) ? $_POST['action'] : '';

$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

try {
    // Conexão com o banco de dados usando PDO
    $conn = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Verifica se o feed existe
    $checkQuery = "SELECT id FROM pinfeeds WHERE id = :feedId";
    $checkStmt = $conn->prepare($checkQuery);
    $checkStmt->bindParam(':feedId', $feedId, PDO::PARAM_INT);
    $checkStmt->execute();
    
    if ($checkStmt->rowCount() > 0) {
        // Atualiza ou insere o like/dislike na tabela likes_dislikes
        $query = "INSERT INTO likes_dislikes (user_id, feed_id, action) 
                  VALUES (:user_id, :feed_id, :action)
                  ON DUPLICATE KEY UPDATE action = :action";
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
        $stmt->bindParam(':feed_id', $feedId, PDO::PARAM_INT);
        $stmt->bindParam(':action', $action, PDO::PARAM_STR);
        $stmt->execute();

        // Verifica a ação e atualiza a contagem na tabela pinfeeds
        if ($action === 'like') {
            // Se foi um "like", atualiza a contagem de likes e remove o dislike se já existia
            $updateFeedQuery = "UPDATE pinfeeds 
                                SET likes = likes + 1, 
                                    dislikes = IF((SELECT action FROM likes_dislikes WHERE user_id = :user_id AND feed_id = :feedId) = 'dislike', dislikes - 1, dislikes)
                                WHERE id = :feedId";
        } elseif ($action === 'dislike') {
            // Se foi um "dislike", atualiza a contagem de dislikes e remove o like se já existia
            $updateFeedQuery = "UPDATE pinfeeds 
                                SET dislikes = dislikes + 1, 
                                    likes = IF((SELECT action FROM likes_dislikes WHERE user_id = :user_id AND feed_id = :feedId) = 'like', likes - 1, likes)
                                WHERE id = :feedId";
        }

        $updateStmt = $conn->prepare($updateFeedQuery);
        $updateStmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
        $updateStmt->bindParam(':feedId', $feedId, PDO::PARAM_INT);

        if ($updateStmt->execute()) {
            echo json_encode(['status' => 'success']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update like/dislike count']);
        }

    } else {
        echo json_encode(['status' => 'error', 'message' => 'Feed not found']);
    }

} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
